@extends ('core.layouts.app')

@section ('title', 'Edit Material Issuance')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Edit Material Issuance</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.assembly.material_issuing.partials.material-issuing-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            {{ Form::model($material_issuing, ['route' => ['biller.material-issuing.update', $material_issuing], 'method' => 'PATCH','files' => true, 'id' => 'edit-material_issuing']) }}
                                <div class="form-group">
                                    @include("focus.assembly.material_issuing.edit_form")
                                    <div class="edit-form-btn ml-2">
                                        {{ link_to_route('biller.material-issuing.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                        {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-primary btn-md']) }}
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
