@extends ('core.layouts.app')

@section ('title', 'Material Issuing')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Material Issuing</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">

                    @include('focus.assembly.material_issuing.partials.material-issuing-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        {{-- <div class="row">
                            <div class="col-2 h4">Product Count</div>
                            <div class="col-2 h4 stock-count">0</div>
                        </div>
                        <div class="row mb-1">
                            <div class="col-2 h4">Total Unit Cost</div>
                            <div class="col-4 h4 stock-worth">0.00</div>
                        </div> --}}
                        <div class="row">
                            <div class="col-3">
                                <label for="date" class="h4">Operator</label>
                                <select class="form-control" name="station" id="station">
                                    <option value="">Select Station</option>
                                    @foreach ($stations as $station)
                                        <option value="{{ $station->id }}">
                                            {{ $station->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-3">
                                <label for="date" class="h4">Date</label>
                                {{ Form::date('issue_date', null ,['class' => 'form-control', 'id' => 'issue_date', '']) }}
                            </div>

                            {{-- <div class="btn-group" role="group" aria-label="Basic example"> --}}
                                {{-- <a href="{{ route( 'biller.material-issuing.view' ) }}" class="btn btn-info  btn-lighten-2 float-right">
                                    <i class="fa fa-list-alt"></i> Report
                                </a> --}}
                            {{-- </div> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <table id="materialIssuing" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Station</th>
                                    <th>Items Issued</th>
                                    {{-- <th>Amount</th> --}}
                                    <th>Issue Time</th>
                                    <th>{{ trans('labels.general.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="100%" class="text-center text-success font-large-1">
                                        <i class="fa fa-spinner spinner"></i>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}" }}
    };

    const Index = {
        stationId: @json(request('station')),
        issueDateId: @json(request('issue_date')),

        init() {
            this.drawDataTable();
            $('#station').val(this.stationId).change(this.stationChange);
            $('#issue_date').val(this.issueDateId).change(this.dateChange);
        },
        stationChange(){
            Index.stationId = $(this).val();
            $('#materialIssuing').DataTable().destroy();
            return Index.drawDataTable();
        },
        dateChange(){
            Index.issueDateId = $(this).val();
            $('#materialIssuing').DataTable().destroy();
            return Index.drawDataTable();
        },
        drawDataTable() {
            $('#materialIssuing').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                stateSave: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: '{{ route("biller.material-issuing.details.get") }}',
                    type: 'post',
                    data: {
                        station: this.stationId,
                        issue_date: this.issueDateId,
                    },
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    {data: 'operator', name: 'operator'},
                    {data: 'items_issued', name: 'items_issued'},
                    // {data: 'amount', name: 'amount'},
                    {data: 'issued_at', name: 'issued_at'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print']
            });
        },
    };

    $(() => Index.init());
</script>
@endsection
