@extends ('core.layouts.app')

@section ('title',  'Purchases  | Create')

@section('page-header')
    <h1>
       Purchases
        <small>Create</small>
    </h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-body">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form method="post" id="data_form">
                                <div class="row">
                                    <div class="col-sm-6 cmp-pnl">
                                        <div id="customerpanel" class="inner-cmp-pnl">
                                            <div class="form-group row">
                                                <div class="fcol-sm-12">
 <h3 class="title">{{trans('purchaseorders.bill_from')}} <a href='#' class="btn btn-primary btn-sm round" data-toggle="modal"  data-target="#addCustomer">
					{{trans('purchaseorders.add_supplier')}}
                                                        </a>
                                                    </h3>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="frmSearch col-sm-12">
                                                    {{ Form::label( 'cst', trans('purchaseorders.search_supplier'),['class' => 'caption']) }}
                                                    {{ Form::text('cst', null, ['class' => 'form-control round user-box', 'placeholder' =>trans('purchaseorders.supplier_search'), 'id'=>'suppliers-box','data-section'=>'suppliers','autocomplete'=>'off']) }}
                                                    <div id="suppliers-box-result"></div>
                                                </div>
                                            </div>

                                            <div id="customer">
                                                <div class="clientinfo">{{trans('purchaseorders.supplier_details')}}
                                                    <hr>
                                                    <div id="customer_name"></div>
                                                </div>
                                                <div class="clientinfo">
                                                    <div id="customer_address1"></div>
                                                </div>
                                                <div class="clientinfo">
                                                    <div id="customer_phone"></div>
                                                </div>
                                                <hr>
                                                <div id="customer_pass"></div>
                                                <hr>
                                            </div>
                                              <div class="form-group row">

                                            {{trans('warehouses.warehouse')}}<select
                                                    id="s_warehouses"
                                                    class="form-control round mt-1">
                                                <option value="0">{{trans('general.all')}}</option>
                                                @foreach($warehouses as $warehouse)
                                                    <option value="{{$warehouse->id}}" {{$warehouse->id==@$defaults[1][0]['feature_value'] ? 'selected' : ''}}>{{$warehouse->title}}</option>
                                                @endforeach
                                            </select>

                                            {{ Form::hidden('supplier_id', '0',['id'=>'customer_id']) }}

</div>
											
										<div class="form-group row">
											
											   <table class="table-responsive tfr">

                                        <thead>
                                <tr class="item_header bg-gradient-directional-blue white">
                                            <th width="25%" class="text-center">Inventory Item</th>
                                            <th width="25%" class="text-center">Expenses</th>
                                            <th width="25%" class="text-center">Asset & Equipment</th>
                                             <th width="25%" class="text-center">Total</th>
                                           
                                        </tr>

                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td class="text-center">222</td>
                                            <td class="text-center">22</td>
                                            <td class="text-center">222</td>
                                             <td class="text-center">222</td>

										</tr>
                                        
                                          <tr class="sub_c" style="display: table-row;">
          
                                            <td align="right" colspan="2"><input type="submit"
                                                                                 class="btn btn-success sub-btn btn-lg"
                                                                                 value="Post Transaction"
                                                                                 id="submit-data"
                                                                                 data-loading-text="Creating...">

                                            </td>
                                        </tr>
										   </tbody>
										   </table>
											
											</div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 cmp-pnl">
                                        <div class="inner-cmp-pnl">


                                            <div class="form-group row">

                                                <div class="col-sm-12"><h3
                                                            class="title">{{trans('purchaseorders.properties')}}</h3>
                                                </div>

                                            </div>
                                            <div class="form-group row">
                                                <div class="col-sm-6"><label for="invocieno"
                                                                             class="caption">{{trans('purchaseorders.tid')}}</label>

                                                    <div class="input-group">
                                                        <div class="input-group-addon"><span class="icon-file-text-o"
                                                          aria-hidden="true"></span>
                                                        </div>

                                                        {{ Form::number('tid', @$last_invoice->tid+1, ['class' => 'form-control round', 'placeholder' => trans('purchaseorders.tid')]) }}
                                                    </div>
                                                </div>
                                                <div class="col-sm-6"><label for="invocieno"
                                                                             class="caption">{{trans('general.reference')}}</label>

                                                    <div class="input-group">
                                                        <div class="input-group-addon"><span class="icon-bookmark-o"
                                                                                             aria-hidden="true"></span>
                                                        </div>
                                                        {{ Form::text('refer', null, ['class' => 'form-control round', 'placeholder' => trans('general.reference')]) }}
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">

                                                <div class="col-sm-6"><label for="invociedate"
                                                                             class="caption">{{trans('purchaseorders.invoicedate')}}</label>

                                                    <div class="input-group">
                                                        <div class="input-group-addon"><span class="icon-calendar4"
                                                                                             aria-hidden="true"></span>
                                                        </div>
                                                        {{ Form::text('invoicedate', null, ['class' => 'form-control round required', 'placeholder' => trans('purchaseorders.invoicedate'),'data-toggle'=>'datepicker','autocomplete'=>'false']) }}
                                                    </div>
                                                </div>
                                                <div class="col-sm-6"><label for="invocieduedate"
                                                                             class="caption">{{trans('purchaseorders.invoiceduedate')}}</label>

                                                    <div class="input-group">
                                                        <div class="input-group-addon"><span class="icon-calendar-o"
                                                                                             aria-hidden="true"></span>
                                                        </div>

                                                        {{ Form::text('invoiceduedate', null, ['class' => 'form-control round required', 'placeholder' => trans('invoices.invoicedate'),'data-toggle'=>'datepicker','autocomplete'=>'false']) }}
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="col-sm-6">
                                                    <label for="taxFormat"
                                                           class="caption">{{trans('general.tax')}}</label>
                                                    <select class="form-control round"
                                                            onchange="changeTaxFormat()"
                                                            id="taxFormat">
                                                        @php
                                                            $tax_format='exclusive';
                                                            $tax_format_id=0;
                                                            $tax_format_type='exclusive';
                                                        @endphp
                                                        @foreach($additionals as $additional_tax)

                                                            @php
                                                                if($additional_tax->id == @$defaults[4][0]['feature_value']  && $additional_tax->class == 1){
                                                                 echo '<option value="'.numberFormat($additional_tax->value).'" data-type1="'.$additional_tax->type1.'" data-type2="'.$additional_tax->type2.'" data-type3="'.$additional_tax->type3.'" data-type4="'.$additional_tax->id.'" selected>--'.$additional_tax->name.'--</option>';
                                                                 $tax_format=$additional_tax->type2;
                                                                 $tax_format_id=$additional_tax->id;
                                                                 $tax_format_type=$additional_tax->type3;
                                                                }

                                                            @endphp
                                                            {!! $additional_tax->class == 1 ? "<option value='".numberFormat($additional_tax->value)."' data-type1='$additional_tax->type1' data-type2='$additional_tax->type2' data-type3='$additional_tax->type3' data-type4='$additional_tax->id'>$additional_tax->name</option>" : "" !!}
                                                        @endforeach

                                                        <option value="0" data-type1="%" data-type2="off"
                                                                data-type3="off">{{trans('general.off')}}</option>
                                                    </select>
                                                </div>
                                                <div class="col-sm-6">

                                                    <div class="form-group">
                                                        <label for="discountFormat"
                                                               class="caption">{{trans('general.discount')}}</label>
                                                        <select class="form-control round"
                                                                onchange="changeDiscountFormat()"
                                                                id="discountFormat">
                                                            @php
                                                                $discount_format='%';
                                                            @endphp
                                                            @foreach($additionals as $additional_discount)
                                                                @php
                                                                    if(@$defaults[3][0]['feature_value'] == $additional_discount->id && $additional_discount->class == 2){
                                                                     echo '<option value="'.$additional_discount->value.'" data-type1="'.$additional_discount->type1.'" data-type2="'.$additional_discount->type2.'" data-type3="'.$additional_discount->type3.'" selected>--'.$additional_discount->name.'--</option>';
                                                                     $discount_format=$additional_discount->type1;
                                                                    }

                                                                @endphp
                                                                {!! $additional_discount->class == 2 ? "<option value='$additional_discount->value' data-type1='$additional_discount->type1' data-type2='$additional_discount->type2' data-type3='$additional_discount->type3'>$additional_discount->name</option>" : "" !!}
                                                            @endforeach

                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="col-sm-12">
                                                    <label for="toAddInfo"
                                                           class="caption">{{trans('general.note')}}</label>

                                                    {{ Form::textarea('notes', null, ['class' => 'form-control round', 'placeholder' => trans('general.note'),'rows'=>'2']) }}
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>



                                  <ul class="nav nav-tabs nav-top-border no-hover-bg nav-justified"
        role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="active-tab1" data-toggle="tab"
               href="#active1" aria-controls="active1" role="tab"
               aria-selected="true">Inventory/Stock Items</a>
        </li>
        <li class="nav-item">
            <a class="nav-link " id="active-tab2" data-toggle="tab"
               href="#active2" aria-controls="active2"
               role="tab">Expenses</a>
        </li>
        <li class="nav-item">
            <a class="nav-link " id="active-tab3" data-toggle="tab"
               href="#active3" aria-controls="active3"
               role="tab">Assets & Equipments</a>
        </li>
       

    </ul>



<div class="tab-content px-1 pt-1">
        <div class="tab-pane active in" id="active1"
             aria-labelledby="active-tab1" role="tabpanel">



                                <div id="saman-row">
                                    <table class="table-responsive tfr my_stripe">

                                        <thead>
                                        <tr class="item_header bg-gradient-directional-blue white">
                                            <th width="30%" class="text-center">{{trans('general.item_name')}}</th>
                                            <th width="8%" class="text-center">{{trans('general.quantity')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.rate')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.tax_p')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.tax')}}</th>
                                            <th width="7%" class="text-center">{{trans('general.discount')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.amount')}}
                                                ({{config('currency.symbol')}})
                                            </th>
                                            <th width="5%" class="text-center">{{trans('general.action')}}</th>
                                        </tr>

                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><input type="text" class="form-control" name="product_name[]"
                                                       placeholder="{{trans('general.enter_product')}}"
                                                       id='productname-0'>
                                            </td>
                                            <td><input type="text" class="form-control req amnt" name="product_qty[]"
                                                       id="amount-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="rowTotal('0'), billUpyog()"
                                                       autocomplete="off" value="1"><input type="hidden" id="alert-0"
                                                                                           value=""
                                                                                           name="alert[]"></td>
                                            <td><input type="text" class="form-control req prc" name="product_price[]"
                                                       id="price-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="rowTotal('0'), billUpyog()"
                                                       autocomplete="off"></td>
                                            <td><input type="text" class="form-control vat " name="product_tax[]"
                                                       id="vat-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="rowTotal('0'), billUpyog()"
                                                       autocomplete="off"></td>
                                            <td class="text-center" id="texttaxa-0">0</td>
                                            <td><input type="text" class="form-control discount"
                                                       name="product_discount[]"
                                                       onkeypress="return isNumber(event)" id="discount-0"
                                                       onkeyup="rowTotal('0'), billUpyog()" autocomplete="off"></td>
                                            <td><span class="currenty">{{config('currency.symbol')}}</span>
                                                <strong><span class='ttlText' id="result-0">0</span></strong></td>
                                            <td class="text-center">

                                            </td>
                                            <input type="hidden" name="total_tax[]" id="taxa-0" value="0">
                                            <input type="hidden" name="total_discount[]" id="disca-0" value="0">
                                            <input type="hidden" class="ttInput" name="product_subtotal[]" id="total-0"
                                                   value="0">
                                            <input type="hidden" class="pdIn" name="product_id[]" id="pid-0" value="0">
                                            <input type="hidden" name="unit[]" id="unit-0" value="">
                                            <input type="hidden" name="code[]" id="hsn-0" value="">
                                            <input type="text" name="taxedvalue[]" id="taxedvalue-0" value="">
                                            <input type="text" name="salevalue[]" id="salevalue-0" value="">
                                            
                                        </tr>
                                        <tr>
                                            <td colspan="2"><textarea id="dpid-0" class="form-control html_editor"
                                                                      name="product_description[]"
                                                                      placeholder="{{trans('general.enter_description')}} (Optional)"
                                                                      autocomplete="off"></textarea><br></td>
                                         <td colspan="4"><input type="text" class="form-control" name="project[]"
                                                       placeholder="Search  Project By Project Name , Clent, Branch"
                                                       id='project-0'>

                                                          <input type="hidden" name="project_id[]" id="project_id-0" >
                                                          <input type="hidden" name="client_id[]" id="client_id-0" >
                                                          <input type="hidden" name="branch_id[]" id="branch_id-0" >
                                            </td>
                                       
                                          
                                          
                                            <td colspan="2"><select class="form-control unit" data-uid="0" name="u_m[]" style="display: none">

                                                </select></td>
                                        </tr>

                                        <tr class="last-item-row sub_c">
                                            <td class="add-row">
                                                <button type="button" class="btn btn-success" aria-label="Left Align"
                                                        id="addproduct">
                                                    <i class="fa fa-plus-square"></i> {{trans('general.add_row')}}
                                                </button>
                                            </td>
                                            <td colspan="7"></td>
                                        </tr>

                                        <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6"
                                                align="right">{{ Form::hidden('subtotal','0',['id'=>'subttlform']) }}
                                                <strong>{{trans('general.total_tax')}}</strong>
                                            </td>
                                            <td align="left" colspan="2"><span
                                                        class="currenty lightMode">{{config('currency.symbol')}}</span>
                                                <span id="taxr" class="lightMode">0</span></td>
                                                <input type="text" name="totalsaleamount" id="totalsaleamount" >
                                                <input type="text" name="totaltaxabe" id="totaltaxabe" >
                                        </tr>
                                        <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6" align="right">
                                                <strong>{{trans('general.total_discount')}}</strong></td>
                                            <td align="left" colspan="2"><span
                                                        class="currenty lightMode"></span>
                                                <span id="discs" class="lightMode">0</span></td>
                                        </tr>

                                        <!--<tr class="sub_c" style="display: table-row;">
                                            <td colspan="6" align="right">
                                                <strong>{{trans('general.shipping')}}</strong></td>
                                            <td align="left" colspan="2"><input type="text" class="form-control shipVal"
                                                                                onkeypress="return isNumber(event)"
                                                                                placeholder="Value"
                                                                                name="shipping" autocomplete="off"
                                                                                onkeyup="billUpyog()">
                                                ( {{trans('general.tax')}} {{config('currency.symbol')}}
                                                <span id="ship_final">0</span> )
                                            </td>
                                        </tr>-->
                                       <!-- <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6" align="right">
                                                <strong> {{trans('general.extra_discount')}}</strong>
                                            </td>
                                            <td align="left" colspan="2"><input type="text"
                                                                                class="form-control form-control-sm discVal"
                                                                                onkeypress="return isNumber(event)"
                                                                                placeholder="Value"
                                                                                name="discount_rate" autocomplete="off"
                                                                                value="0"
                                                                                onkeyup="billUpyog()">
                                                <input type="hidden"
                                                       name="after_disc" id="after_disc" value="0">
                                                ( {{config('currency.symbol')}}
                                                <span id="disc_final">0</span> )
                                            </td>
                                        </tr>-->


                                        <tr class="sub_c" style="display: table-row;">
                                      
                                            <td colspan="6" align="right"><strong>{{trans('general.grand_total')}}
                                                    (<span
                                                            class="currenty lightMode">{{config('currency.symbol')}}</span>)</strong>
                                            </td>
                                            <td align="left" colspan="2"><input type="text" name="total"
                                                                                class="form-control"
                                                                                id="invoiceyoghtml" readonly="">

                                            </td>
                                        </tr>
                                      
                                        </tbody>
                                    </table>
                                    <div class="row mt-3">
                                        <div class="col-12">{!! $fields !!}</div>
                                    </div>


                                </div>


                                    </div>

                                    <!---endtab1-->



                                      <div class="tab-pane" id="active2" aria-labelledby="link-tab2"
             role="tabpanel">



              <div id="saman-row-exp">
                                    <table class="table-responsive tfr my_stripe">

                                        <thead>
                                        <tr class="item_header bg-gradient-directional-danger white">
                                            <th width="30%" class="text-center">Ledger Name</th>
                                            <th width="8%" class="text-center">{{trans('general.quantity')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.rate')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.tax_p')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.tax')}}</th>
                                            <th width="7%" class="text-center">{{trans('general.discount')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.amount')}}
                                                ({{config('currency.symbol')}})
                                            </th>
                                            <th width="5%" class="text-center">{{trans('general.action')}}</th>
                                        </tr>

                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><input type="text" class="form-control" name="ledger_name[]"
                                                       placeholder="Enter Ledger"
                                                       id='ledgername-0'>
                                            </td>
                                            <td><input type="text" class="form-control req exp_amnt" name="exp_product_qty[]"
                                                       id="exp_amount-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="expRowTotal('0'), expBillUpyog()"
                                                       autocomplete="off" value="1">
                                           </td>
                                            <td><input type="text" class="form-control req exp_prc" name="exp_product_price[]"
                                                       id="exp_price-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="expRowTotal('0'), expBillUpyog()"
                                                       autocomplete="off"></td>
                                            <td><input type="text" class="form-control exp_vat " name="exp_product_tax[]"
                                                       id="exp_vat-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="expRowTotal('0'), expBillUpyog()"
                                                       autocomplete="off"></td>
                                            <td class="text-center" id="exp_texttaxa-0">0</td>
                                            <td><input type="text" class="form-control exp_discount"
                                                       name="exp_product_discount[]"
                                                       onkeypress="return isNumber(event)" id="exp_discount-0"
                                                       onkeyup="expRowTotal('0'), expBillUpyog()" autocomplete="off"></td>
                                            <td><span class="exp_currenty">{{config('currency.symbol')}}</span>
                                                <strong><span class='exp_ttlText' id="exp_result-0">0</span></strong></td>
                                            <td class="text-center">

                                            </td>
                                            <input type="hidden" name="exp_total_tax[]" id="exp_taxa-0" value="0">
                                            <input type="hidden" name="exp_total_discount[]" id="exp_disca-0" value="0">
                                            <input type="hidden" class="exp_ttInput" name="exp_product_subtotal[]" id="exp_total-0"
                                                   value="0">
                                            <input type="hidden" class="exp_pdIn" name="ledger_id[]" id="exp_pid-0" value="0">
                                          
                                        
                                        </tr>
                                        <tr>
                                            <td colspan="3"><textarea id="exp_dpid-0" class="form-control html_editor"
                                                                      name="exp_product_description[]"
                                                                      placeholder="{{trans('general.enter_description')}} (Optional)"
                                                                      autocomplete="off"></textarea><br></td>
                                         <td colspan="5"><input type="text" class="form-control" name="exp_project[]"
                                                       placeholder="Search  Project By Project Name , Clent, Branch"
                                                       id='exp_project-0'>

                                                          <input type="hidden" name="exp_project_id[]" id="exp_project_id-0" >
                                                          <input type="hidden" name="exp_client_id[]" id="exp_client_id-0" >
                                                          <input type="hidden" name="exp_branch_id[]" id="exp_branch_id-0" >
                                            </td>
                                       
                                          
                                          
                                          
                                        </tr>

                                        <tr class="last-item-row-exp sub_c">
                                            <td class="add-row">
                                                <button type="button" class="btn btn-success" aria-label="Left Align"
                                                        id="expaddproduct">
                                                    <i class="fa fa-plus-square"></i> {{trans('general.add_row')}}
                                                </button>
                                            </td>
                                            <td colspan="7"></td>
                                        </tr>

                                        <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6"
                                                align="right">{{ Form::hidden('subtotal','0',['id'=>'exp_subttlform']) }}
                                                <strong>{{trans('general.total_tax')}}</strong>
                                            </td>
                                            <td align="left" colspan="2"><span
                                                        class="currenty lightMode">{{config('currency.symbol')}}</span>
                                                <span id="exp_taxr" class="lightMode">0</span></td>
                                        </tr>
                                        <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6" align="right">
                                                <strong>{{trans('general.total_discount')}}</strong></td>
                                            <td align="left" colspan="2"><span
                                                        class="currenty lightMode"></span>
                                                <span id="exp_discs" class="lightMode">0</span></td>
                                        </tr>

                                  
                                        <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6" align="right">
                                                <strong> {{trans('general.extra_discount')}}</strong>
                                            </td>
                                <td align="left" colspan="2"><input type="text"
                            class="form-control form-control-sm exp_discVal"
                            onkeypress="return isNumber(event)"
                            placeholder="Value" name="exp_discount_rate" autocomplete="off"
                            value="0" onkeyup="expBillUpyog()">
                            <input type="hidden" name="exp_after_disc" id="exp_after_disc" value="0">
                                                ( {{config('currency.symbol')}}
                                                <span id="exp_disc_final">0</span> )
                                            </td>
                                        </tr>


                                        <tr class="sub_c" style="display: table-row;">
                                           
                                            <td colspan="6" align="right"><strong>{{trans('general.grand_total')}}
                                                    (<span
                                                            class="currenty lightMode">{{config('currency.symbol')}}</span>)</strong>
                                            </td>
                                            <td align="left" colspan="2"><input type="text" name="exp_total"
                                                                                class="form-control"
                                                                                id="exp_invoiceyoghtml" readonly="">

                                            </td>
                                        </tr>
                                     
                                        </tbody>
                                    </table>
                                    <div class="row mt-3">
                                        <div class="col-12">{!! $fields !!}</div>
                                    </div>

                                    
                                </div>

</div>


   <!---endtab2-->

    <div class="tab-pane" id="active3" aria-labelledby="link-tab3"
             role="tabpanel">
<div id="saman-row-item">
                                    <table class="table-responsive tfr my_stripe">

                                        <thead>
                                        <tr class="item_header bg-gradient-directional-success white">
                                            <th width="30%" class="text-center">{{trans('general.item_name')}}</th>
                                            <th width="8%" class="text-center">{{trans('general.quantity')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.rate')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.tax_p')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.tax')}}</th>
                                            <th width="7%" class="text-center">{{trans('general.discount')}}</th>
                                            <th width="10%" class="text-center">{{trans('general.amount')}}
                                                ({{config('currency.symbol')}})
                                            </th>
                                            <th width="5%" class="text-center">{{trans('general.action')}}</th>
                                        </tr>

                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><input type="text" class="form-control" name="item_name[]"
                                                       placeholder="Enter Assets Or Equipments Name"
                                                       id='itemname-0'>
                                            </td>
                                            <td><input type="text" class="form-control req item_amnt" name="item_product_qty[]"
                                                       id="item_amount-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="itemRowTotal('0'), itemBillUpyog()"
                                                       autocomplete="off" value="1">
                                           </td>
                                            <td><input type="text" class="form-control req item_prc" name="item_product_price[]"
                                                       id="item_price-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="itemRowTotal('0'), itemBillUpyog()"
                                                       autocomplete="off"></td>
                                            <td><input type="text" class="form-control item_vat " name="item_product_tax[]"
                                                       id="item_vat-0"
                                                       onkeypress="return isNumber(event)"
                                                       onkeyup="itemRowTotal('0'), itemBillUpyog()"
                                                       autocomplete="off"></td>
                                            <td class="text-center" id="item_texttaxa-0">0</td>
                                            <td><input type="text" class="form-control item_discount"
                                                       name="item_product_discount[]"
                                                       onkeypress="return isNumber(event)" id="item_discount-0"
                                                       onkeyup="itemRowTotal('0'), itemBillUpyog()" autocomplete="off"></td>
                                            <td><span class="item_currenty">{{config('currency.symbol')}}</span>
                                                <strong><span class='item_ttlText' id="item_result-0">0</span></strong></td>
                                            <td class="text-center">

                                            </td>
                                            <input type="hidden" name="item_total_tax[]" id="item_taxa-0" value="0">
                                            <input type="hidden" name="item_total_discount[]" id="item_disca-0" value="0">
                                            <input type="hidden" class="item_ttInput" name="item_product_subtotal[]" id="item_total-0"
                                                   value="0">
                                            <input type="hidden" class="item_pdIn" name="item_id[]" id="item_pid-0" value="0">
                                            <input type="hidden"  name="account_id[]" id="account_id-0" value="0">
                                            <input type="hidden"  name="account_type[]" id="account_type-0" >
                                          
                                        
                                        </tr>
                                        <tr>
                                            <td colspan="3"><textarea id="item_dpid-0" class="form-control html_editor"
                                                                      name="item_product_description[]"
                                                                      placeholder="{{trans('general.enter_description')}} (Optional)"
                                                                      autocomplete="off"></textarea><br></td>
                                         <td colspan="5"><input type="text" class="form-control" name="item_project[]"
                                                       placeholder="Search  Project By Project Name , Clent, Branch"
                                                       id='item_project-0'>

                                                          <input type="hidden" name="item_project_id[]" id="item_project_id-0" >
                                                          <input type="hidden" name="item_client_id[]" id="item_client_id-0" >
                                                          <input type="hidden" name="item_branch_id[]" id="item_branch_id-0" >
                                            </td>
                                       
                                          
                                          
                                          
                                        </tr>

                                        <tr class="last-item-row-item sub_c">
                                            <td class="add-row">
                                                <button type="button" class="btn btn-success" aria-label="Left Align"
                                                        id="itemaddproduct">
                                                    <i class="fa fa-plus-square"></i> {{trans('general.add_row')}}
                                                </button>
                                            </td>
                                            <td colspan="7"></td>
                                        </tr>

                                        <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6"
                                                align="right">{{ Form::hidden('subtotal','0',['id'=>'item_subttlform']) }}
                                                <strong>{{trans('general.total_tax')}}</strong>
                                            </td>
                                            <td align="left" colspan="2"><span
                                                        class="currenty lightMode">{{config('currency.symbol')}}</span>
                                                <span id="item_taxr" class="lightMode">0</span></td>
                                        </tr>
                                        <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6" align="right">
                                                <strong>{{trans('general.total_discount')}}</strong></td>
                                            <td align="left" colspan="2"><span
                                                        class="currenty lightMode"></span>
                                                <span id="item_discs" class="lightMode">0</span></td>
                                        </tr>

                                  
                                        <tr class="sub_c" style="display: table-row;">
                                            <td colspan="6" align="right">
                                                <strong> {{trans('general.extra_discount')}}</strong>
                                            </td>
                                <td align="left" colspan="2"><input type="text"
                            class="form-control form-control-sm item_discVal"
                            onkeypress="return isNumber(event)"
                            placeholder="Value" name="item_discount_rate" autocomplete="off"
                            value="0" onkeyup="itemBillUpyog()">
                            <input type="hidden" name="item_after_disc" id="item_after_disc" value="0">
                                                ( {{config('currency.symbol')}}
                                                <span id="item_disc_final">0</span> )
                                            </td>
                                        </tr>


                                        <tr class="sub_c" style="display: table-row;">
                                           
                                            <td colspan="6" align="right"><strong>{{trans('general.grand_total')}}
                                                    (<span
                                                            class="currenty lightMode">{{config('currency.symbol')}}</span>)</strong>
                                            </td>
                                            <td align="left" colspan="2"><input type="text" name="item_total"
                                                                                class="form-control"
                                                                                id="item_invoiceyoghtml" readonly="">

                                            </td>
                                        </tr>
                                     
                                        </tbody>
                                    </table>
                                    <div class="row mt-3">
                                        <div class="col-12">{!! $fields !!}</div>
                                    </div>

                                    
                                </div>

             </div>





                                        </div>













                                <input type="hidden" value="new_i" id="inv_page">
                                <input type="hidden" value="{{route('biller.purchaseorders.store')}}" id="action-url">
                                <input type="hidden" value="search" id="billtype">
                                <input type="hidden" value="0" name="counter" id="ganak">
                                 <input type="hidden" value="0" name="counter" id="expganak">
                                 <input type="hidden" value="0" name="counter" id="itemganak">
                                <input type="hidden" value="{{$tax_format}}" name="tax_format_static" id="tax_format">
                                <input type="hidden" value="{{$tax_format_type}}" name="tax_format"
                                       id="tax_format_type">
                                <input type="hidden" value="{{$tax_format_id}}" name="tax_id" id="tax_format_id">
                                <input type="hidden" value="{{$discount_format}}"
                                       name="discount_format" id="discount_format">

                                @if(@$defaults[4][0]->ship_tax['id']>0) <input type='hidden'
                                                                              value='{{numberFormat($defaults[4][0]->ship_tax['value'])}}'
                                                     name='ship_rate' id='ship_rate'><input
                                        type='hidden' value='{{$defaults[4][0]->ship_tax['type2']}}'
                                        name='ship_tax_type'
                                        id='ship_taxtype'>
                                @else
                                    <input type='hidden'
                                           value='{{numberFormat(0)}}'
                                           name='ship_rate' id='ship_rate'><input
                                            type='hidden' value='none' name='ship_tax_type'
                                            id='ship_taxtype'>
                                @endif


                                <input type="hidden" value="0" name="ship_tax" id="ship_tax">
                                <input type="hidden" value="0" id="custom_discount">
                                

                            </form>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
    @include("focus.modal.supplier")
@endsection
@section('extra-scripts')
    <script type="text/javascript">
               $(function () {
            $('[data-toggle="datepicker"]').datepicker({
                autoHide: true,
                format: '{{config('core.user_date_format')}}'
            });
            $('[data-toggle="datepicker"]').datepicker('setDate', '{{date(config('core.user_date_format'))}}');
            editor();
        });


    </script>
@endsection
