<div class='row'>
    <div class='col-md-6'>
        <div class='form-group'>
            <div class="col-12">
                {{ Form::label('account_id', 'Source Account',['class' => 'control-label']) }}
                <select name="credit_ledger_id" class='custom-select' required>
                    <option value="">-- Select Source Account --</option>
                    @foreach($accounts as $row)
                        <option value="{{ $row->id }}" {{ @$banktransfer->credit_ledger_id == $row->id? 'selected' : '' }}>
                            {{ $row->name }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class='col-md-2'>
        <div class='form-group'>
            <div class='col-12 p-0'>
                {{ Form::label('transaction_date', 'Transaction Date', ['class' => 'control-label']) }}
                <fieldset class="form-group position-relative has-icon-left">
                    <input type="text" class="form-control  datepicker" placeholder="{{trans('general.payment_date')}}*" name="date">
                    <div class="form-control-position">
                        <span class="fa fa-calendar" aria-hidden="true"></span>
                    </div>
                </fieldset>
            </div>
        </div>
    </div>

    <div class='col-md-2'>
        <div class='form-group'>
            <div class="col-12 p-0">
                {{ Form::label('method', 'Transaction Method', ['class' => 'control-label']) }}
                <select name="doc_reference" class='custom-select'>
                    @foreach(['Cash', 'Mpesa', 'EFT', 'Cheque'] as $val)
                        <option value="{{ $val }}" {{ @$banktransfer == $val? 'selected' : ''}}>{{ $val }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class='col-md-2'>
        <div class='form-group'>
            <div class='col-12 p-0'>
                {{ Form::label( 'refer_no', 'Reference No',['class' => 'control-label']) }}
                {{ Form::text('reference', null, ['class' => 'form-control ', 'placeholder' => 'Reference No', 'id' => 'refer_no']) }}
            </div>
        </div>
    </div>
</div>

<div class='row'>
    <div class='col-md-6'>
        <div class='form-group'>
            <div class="col-12">     
                {{ Form::label('debit_account_id', 'Destination Account', ['class' => 'control-label']) }}           
                <select name="debit_ledger_id" class='custom-select' required>
                    <option value="">-- Select Destination Account --</option>
                    @foreach($accounts as $row)
                        <option value="{{ $row->id }}" {{ @$banktransfer->debit_ledger_id == $row->id? 'selected' : '' }}>
                            {{ $row->name }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class='col-md-4'>
        <div class='form-group'>
            <div class="col-12 p-0">
                {{ Form::label('amount', 'Amount', ['class' => 'control-label']) }}
                {{ Form::text('amount', numberFormat(@$banktransfer->amount), ['class' => 'form-control  required', 'placeholder' => 'Amount', 'id' => 'amount', 'required']) }}
            </div>
        </div>
    </div>
</div>

<div class='row'>
    <div class='col-md-10'>
        <div class='form-group'>
            {{ Form::label( 'note', trans('general.note'),['class' => 'col-6 control-label']) }}
            <div class='col'>
                {{ Form::text('note', null, ['class' => 'form-control ', 'placeholder' => trans('general.note'), 'id' => 'note']) }}
            </div>
        </div>
    </div>
</div>


@section("after-scripts")
<script type="text/javascript">
    const config = {
        date: {format: "{{ config('core.user_date_format') }}", autoHide: true},
    }

    const Form = {
        banktransfer: @json(@$banktransfer),

        init() {
            $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
            if (Form.banktransfer.id) Form.handleEdit(Form.banktransfer);
        },

        handleEdit(banktransfer) {
            $('.datepicker').datepicker('setDate', new Date(banktransfer.date));
        },
    };

    $(Form.init);
</script>
@endsection