<html>

<head>
    <style>
        body {
            font-family: "Times New Roman", Times, serif;
            font-size: 10pt;
        }

        table {
            font-family: "Myriad Pro", "Myriad", "Liberation Sans", "Nimbus Sans L", "Helvetica Neue", Helvetica, Arial, sans-serif;
            font-size: 8pt;
        }

        table thead td {
            background-color: #FFFFFF;
            text-align: center;
            border: 0.1mm solid black;
            font-variant: small-caps;
        }

        thead th {
            background-color: #1c1a1a;
            color: white;
        }

        thead .no {
            border: none;
        }

        td {
            vertical-align: top;
        }

        .tds td {
            background-color: gray;
        }

        .jobcard {
            background-color: #888888;
        }

        th {
            background-color: #FFFFFF;
        }

        .bullets {
            width: 8px;
        }

        .items {
            border-bottom: 0.1mm solid black;
            font-size: 7pt;
            border-collapse: collapse;
            width: 100%;
            font-family: sans-serif;
        }

        .items td {
            border-left: 0.1mm solid black;
            border-right: 0.1mm solid black;
        }

        .items-tb {
            border-bottom: 0.1mm solid black;
            font-size: 7pt;
            border-collapse: collapse;
            width: 100%;
            font-family: sans-serif;
        }

        .items-tb td {
            border-left: 0.1mm solid black;
            border-right: 0.1mm solid black;
            border-bottom: 0.1mm solid black;
            border-top: 0.1mm solid black;
        }

        .align-r {
            text-align: right;
        }

        .align-c {
            text-align: center;
        }

        .align-l {
            text-align: left;
        }

        .bd {
            border: 1px solid black;
        }

        .bd-t {
            border-top: 1px solid
        }

        .ref {
            width: 100%;
            font-family: serif;
            font-size: 7pt;
            border-collapse: collapse;
        }

        .ref tr td {
            border: 0.1mm solid #888888;
        }

        .ref tr:nth-child(2) td {
            width: 50%;
        }

        .customer-dt {
            width: 100%;
            font-family: serif;
            font-size: 7pt;
        }

        .customer-dt tr td:nth-child(1) {
            border: 0.1mm solid #888888;
        }

        .customer-dt tr td:nth-child(3) {
            border: 0.1mm solid #888888;
        }

        .customer-dt-title {
            font-size: 7pt;
            color: #555555;
            font-family: sans;
        }

        .doc-title-td {
            text-align: center;
            width: 100%;
        }

        .doc-title {
            font-size: 7pt;
            color: #0f4d9b;
        }

        .doc-table {
            font-size: 7pt;
            margin-top: 5px;
            width: 100%;
        }

        .header-table {
            width: 15%;
        }

        .header-table1 {
            width: 75%;
        }

        .header-tables {
            width: 25%;
        }

        .header-table tr td:first-child {
            /* color: #0f4d9b; */
            font-size: 7pt;
            width: 5%;
            text-align: left;
        }

        .address {
            color: #0f4d9b;
            font-size: 10pt;
            width: 40%;
            text-align: right;
        }

        .header-table-text {
            /* color:#0f4d9b;  */
            font-size: 7pt;
            margin: 0;
        }

        .header-table-child {
            color: #0f4d9b;
            font-size: 7pt;
        }

        .header-table-child tr:nth-child(2) td {
            font-size: 7pt;
            padding-left: 5px;
        }

        .footer {
            font-size: 7pt;
            text-align: center;
        }

        .float-right {
            float: right;
            border: 0.1mm solid #888888;
        }

        .mt-5 {
            margin-top: 65px;
        }

        .mt-1 {
            margin-top: 5px;
        }

        .borders {
            border: 1px solid black;
            border-collapse: collapse;
            text-align: center;
        }

        .row {
            display: -webkit-box;
            display: -webkit-flex;
            display: -moz-box;
            display: -ms-flexbox;
            display: flex;
            -webkit-flex-wrap: wrap;
            -ms-flex-wrap: wrap;
            flex-wrap: wrap;
            /* margin-right: -15px;
   margin-left: -15px */
        }

        .ml-5 {
            margin-left: 100px;
        }

        .item-center h4 {
            justify-items: center;
        }

        .table-taxable {
            width: 98%;
            margin: .5rem;
        }

        .table-header {
            width: 5%;
            margin: .5rem;
        }

        .table-header-right {
            width: 45%;
            margin: .5rem;
        }

        .head-table {
            width: 50%;
        }

        .head-table1 {
            width: 65%;
        }

        .comment {
            width: 35%;
            margin: .5rem;
        }

        .tray {
            width: 65%;
            margin: .5rem;
        }

        .item {
            border-bottom: 0.1mm solid black;
            font-size: 7pt;
            border-collapse: collapse;
            width: 100%;
            font-family: sans-serif;
        }

        .item td {
            border-left: none;
            border-right: none;
        }

        .item-comment {
            border-bottom: 0.1mm solid black;
            font-size: 7pt;
            border-collapse: collapse;
            width: 35%;
            font-family: sans-serif;
        }

        .item-comment td {
            border-left: 0.1mm solid black;
            border-right: 0.1mm solid black;
        }

        /* h4 {
   text-align: center;
  } */
        table.items {
            border: 0.1mm solid #000000;
        }

        table {
            font-family: "Century Gothic", CenturyGothic, AppleGothic, sans-serif;
            font-size: 13pt;
        }

        td {
            vertical-align: top;
        }

        .items td {
            border-left: 0.1mm solid #000000;
            border-right: 0.1mm solid #000000;
        }

        table thead td {
            background-color: #EEEEEE;
            text-align: center;
            border: 0.1mm solid #000000;
            font-variant: small-caps;
        }

        .items td.blanktotal {
            background-color: #EEEEEE;
            border: 0.1mm solid #000000;
            background-color: #FFFFFF;
            border: 0mm none #000000;
            border-top: 0.1mm solid #000000;
            border-right: 0.1mm solid #000000;
        }

        .items td.totals {
            text-align: right;
            border: 0.1mm solid #000000;
        }

        .items td.totalsy {
            border: 0.1mm solid #000000;
        }

        .dotted td {
            border-bottom: 0.1mm solid #000000;
        }

        table.heading {
            border: none;
        }

        .heading {
            border-bottom: 0.1mm solid black;
            font-size: 7pt;
            border-collapse: collapse;
            width: 100%;
            font-family: sans-serif;
        }
    </style>
</head>

<body>
    <div style="width: 100%;">
        <div style="width: 35%;float:left">
            <table class="items">
                <tr class="dotted">
                    <td style="padding:3px;">
                        <h2>Job Card Number:</h2>
                    </td>
                    <td class="jobcard" style="padding:3px;color:">
                        <h2>{{ $resource->jobcard_no }}</h2>
                    </td>
                </tr>
            </table>
        </div>
        <div style="width: 40%;float:right">
            <table class="items">
                <tr class="dotted">
                    <td width="20%">
                        <h5>JC Date</h5>
                    </td>
                    <td width="20%">
                        {{ $resource->jobcard_date }}
                    </td>
                </tr>
                <tr class="dotted">
                    <td width="20%">
                        <h5>Type</h5>
                    </td>
                    <td width="20%">
                        {{ $resource->type }}
                    </td>
                </tr>
                <tr class="dotted">
                    <td width="20%">
                        <h5>Total B/M Board</h5>
                    </td>
                    <td width="20%">
                        {{ NumberFormat($resource->total_board) }}
                    </td>
                </tr>
                <tr class="dotted">
                    <td width="20%">
                        <h5>Total Qty</h5>
                    </td>
                    <td width="20%">
                        {{ NumberFormat($resource->total_qty) }}
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <table class="heading" style="margin-top:5px;margin-bottom:10px;">
        <tr>
            <td style="width:15%">
                <h3>Customer Name:</h3>
            </td>
            <td style="width: 85%" class="tds">
                <h2>{{ @$resource->customer->company }}</h2>
            </td>
        </tr>
        <tr>
            <td style="width:15%">
                <h3>Description:</h3>
            </td>
            <td style="width: 85%" class="tds">
                <h2>{{ $resource->description }}</h2>
            </td>
        </tr>
    </table>
    {{-- <table class="doc-table">
		<tr>
			<td class="doc-title-td">
				<span class='doc-title'>
				</span>				
			</td>
		</tr>
	</table><br> --}}
    <div style="width:100%">
        <div style="width: 40%;float:left">
            <div style="width:100%;margin-bottom:5px">
                <div style="width: 40%;float:left">
                    <table class="items">
                        <tr class="dotted">
                            <td class="borders">Length</td>
                            <td class="borders">Width</td>
                            <td class="borders">Height</td>
                        </tr>
                        <tr class="dotted">
                            <td class="borders">{{ NumberFormat($resource->length) }}</td>
                            <td class="borders">{{ NumberFormat($resource->width) }}</td>
                            <td class="borders">{{ NumberFormat($resource->height) }}</td>
                        </tr>
                    </table>
                </div>
                <div style="width: 55%;float:left;margin-left:10px;">
                    <table class="items">
                        <tr class="dotted">
                            <td>Flute</td>
                            <td>
                                {{ $resource->flute }}
                            </td>
                        </tr>
                        <tr class="dotted">
                            <td>No. of Outs</td>
                            <td>
                                {{ NumberFormat($resource->no_of_outs) }}
                            </td>
                        </tr>
                        <tr class="dotted">
                            <td>No of Chops</td>
                            <td>
                                {{ NumberFormat($resource->no_of_chops) }}
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <div style="width: 100%;">
                <div style="width: 5%;float:left">
                    <div style="margin-top:10px;">
                        <table style="width:100%;font-size:6pt;font-weight;bold">
                            <tr>
                                <td text-rotate="90">666</td>
                            </tr>
                        </table>
                    </div>
                    <div style="margin-top:25px;">
                        <table style="width:100%;font-size:6pt;font-weight;bold">
                            <tr>
                                <td text-rotate="90">444</td>
                            </tr>
                        </table>
                    </div>
                    <div style="margin-top:20px;">
                        <table style="width:100%;font-size:6pt;font-weight;bold">
                            <tr>
                                <td text-rotate="90">233</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div style="width: 85%;float:left"><img
                        src="{{ Storage::disk('public')->url('app/public/img/company/customer_board.png') }}"
                        style="object-fit:contain" width="100%" /></div>
                <div style="width: 10%;float:left">
                    <table style="width:100%;font-size:6pt;margin-top:40px;font-weight;bold">
                        <tr>
                            <td text-rotate="90">555</td>
                        </tr>
                    </table>
                </div>
            </div>
            <div style="width: 100%;">
                <table style="width:100%;font-size:6pt;margin-left:120px;">
                    <tr>
                        <td>77777</td>
                    </tr>
                </table>
            </div>
        </div>
        <div style="width: 60%;float:left">
            <div style="width: 100%;">
                <table class="items">
                    <tr class="dotted">
                        <td colspan="6" style="font-weight:bold" align="center">Paper Requirement</td>
                    </tr>
                    <tr class="dotted">
                        <td></td>
                        <td>Reel Size</td>
                        <td colspan="2">GSM</td>
                        <td>Meters</td>
                        <td>Tons</td>
                    </tr>
                    <tbody>
                        @foreach ($resource->items as $item)
                            <tr class="dotted">
                                <td class="borders">{{ $item->liner_name }}</td>
                                <td class="borders">{{ NumberFormat($item->reel_size) }}</td>
                                <td class="borders">
                                    {{ NumberFormat($item->gsm_value) }}
                                </td>
                                <td class="borders">{{ $item->kraft_liner }}</td>
                                <td class="borders">{{ NumberFormat($item->meters) }}</td>
                                <td class="borders">{{ $item->tones }}</td>
                            </tr>
                        @endforeach
                        <tr class="dotted">
                            <td class="borders">Total</td>
                            <td class="borders"></td>
                            <td class="borders"></td>
                            <td class="borders"></td>
                            <td class="borders"></td>
                            <td class="borders">{{ $resource->total_tones }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div style="width: 100%;">
                <table class="items" cellpadding="2">
                    <tr class="dotted">
                        <td colspan="7" style="font-weight:bold"  align="center">Creasing Pattern</td>
                    </tr>
                    <tr class="dotted">
                        <td class="borders">{{ NumberFormat($resource->crease_part1) }}</td>
                        <td class="borders" colspan="8"></td>
                    </tr>
                    <tr class="dotted">
                        <td class="borders">{{ NumberFormat($resource->crease_part2) }}</td>
                        <td class="borders">{{ $resource->cp2_1 }}</td>
                        <td class="borders">{{ $resource->cp2_2 }}</td>
                        <td class="borders">{{ $resource->cp2_3 }}</td>
                        <td class="borders">{{ $resource->cp2_4 }}</td>
                        <td class="borders">{{ $resource->cp2_5 }}</td>
                        <td class="borders">{{ $resource->cp2_6 }}</td>
                    </tr>
                    <tr class="dotted">
                        <td class="borders">{{ NumberFormat($resource->crease_part3) }}</td>
                        <td class="borders" colspan="2">{{ $resource->cp3_1 }}</td>
                        <td class="borders" colspan="2">{{ $resource->cp3_2 }}</td>
                        <td class="borders" colspan="2">{{ $resource->cp3_3 }}</td>
                    </tr>
                    <tr class="dotted">
                        <td class="borders">{{ NumberFormat($resource->crease_part4) }}</td>
                        <td class="borders" colspan="8"></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div style="width: 100%;">
        <div style="width: 40%;float:left;padding-top:25x;">
            <table class="items">
                <tr class="dotted">
                    <td class="borders" style=""><b>Carton/Bundle</b></td>
                    <td class="borders">
                        {{ $resource->cortons_bundle }}
                    </td>
                </tr>
                <tr class="dotted">
                    <td class="borders"><b>Mfg Joint</b></td>
                    <td class="borders">
                        {{ $resource->mfg_joint }}
                    </td>
                </tr>
                <tr class="dotted">
                    <td class="borders"><b>Die No.</b></td>
                    <td class="borders">
                        {{ NumberFormat($resource->die_no) }}
                    </td>
                </tr>
                <tr class="dotted">
                    <td class="borders"><b>Diecut Outs:</b></td>
                    <td class="borders">
                        {{ NumberFormat($resource->die_cut_outs) }}
                    </td>
                </tr>
                <tr class="dotted">
                    <td class="borders"><b>SHEET WEIGHT (g)</b></td>
                    <td class="borders">
                        {{ NumberFormat($resource->sheet_weight) }}
                    </td>
                </tr>
            </table>
        </div>
        <div style="width: 60%;float:left;">
            <div style="width: 100%;font-size:6pt">
                <div style="width: 95%;float:left;"><img
                        src="{{ Storage::disk('public')->url('app/public/img/company/Board_box.png') }}"
                        style="object-fit:contain" width="100%" />
                </div>
                <div style="width: 5%;float:left;">
                    <table style="width:100%;font-size:6pt;margin-top:70px">
                        <tr>
                            <td text-rotate="90">999999</td>
                        </tr>
                    </table>
                </div>
            </div>
            <div style="width: 100%;font-size:6pt">
                <div style="width: 10%;float:left;margin-left:5px;">One</div>
                <div style="width: 20%;float:left;padding-left:1px;">Two</div>
                <div style="width: 22%;float:left;padding-left:2px;">Three</div>
                <div style="width: 22%;float:left;margin-left:3px;">Four</div>
                <div style="width: 20%;float:left;">Five</div>
            </div>
        </div>
    </div>

    <table class="items-tb" cellpadding="4" style="margin-top:10px ">
        <thead>
            <tr>
                <th>Process</th>
                <th>Date</th>
                <th>Operator Name</th>
                <th>Start Time</th>
                <th>End Time</th>
                <th>Recd. Qty</th>
                <th>B.Rej</th>
                <th>Qty. Prod</th>
                <th>Print Rej.</th>
                <th>Net Qty</th>
                <th>Opt Sign</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($resource->processes as $process)
                <tr>
                    <td class="borders">{{ $process->process_item->process_name }}</td>
                    <td class="borders">{{ $process->date }}</td>
                    <td class="borders">
                        {{ $process->hrm ? $process->hrm->first_name . ' ' . $process->hrm->last_name : '' }}</td>
                    <td class="borders">{{ $process->start_time }}</td>
                    <td class="borders">{{ $process->end_time }}</td>
                    <td class="borders">{{ $process->record_qty }}</td>
                    <td class="borders">{{ $process->board_rej }}</td>
                    <td class="borders">{{ $process->qty_produced }}</td>
                    <td class="borders">{{ $process->print_rej }}</td>
                    <td class="borders">{{ $process->net_qty }}</td>
                    <td class="borders">{{ $process->operator_sign }}</td>
                </tr>
            @endforeach
            <tr>
                <td class="align-c" colspan="12">Total Rejection</td>
            </tr>
        </tbody>
    </table>
    <br>
    <table class="items-tb" cellpadding="4">
        <thead>
            <tr>
                <th></th>
                @foreach ($resource->dispatch as $dispatch)
                    <th>
                        {{ $dispatch->dispatch_name }}
                    </th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach ($resource->dispatch_category as $category)
                <tr>
                    <td>{{ $category->name }}</td>
                    {{-- @foreach ($category->dispatch_category_items as $item)
						<td>{{$item->dispatch_value}}</td>
					@endforeach --}}
                    @foreach ($resource->dispatch as $item)
                        <td>
                            @foreach ($item->dispatch_items as $dis_item)
                                {{-- {{dd($dis_item->dispatch_value)}} --}}
                                @if ($dis_item->dispatch_category_id === $category->id)
                                    {{ $dis_item->dispatch_value }}
                                    <br>
                                @endif
                            @endforeach
                        </td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
