{{ Html::script('focus/js/select2.min.js') }}
<script>
    config = {
        ajax: { headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"} },
        date: {format: "{{config('core.user_date_format')}}", autoHide: true},
        customerSelect: {
            allowClear: true,
            ajax: {
                url: "{{ route('biller.customers.select') }}",
                dataType: 'json',
                type: 'POST',
                quietMillis: 50,
                data: ({term}) => ({search: term}),
                processResults: result => {
                    return { results: result.map(v => ({text: `${v.name} - ${v.company}`, id: v.id }))};
                }      
            }
        },
        invoiceSelect: {
            allowClear: true,
            ajax: {
                url: "{{ route('biller.invoices.select') }}",
                dataType: 'json',
                type: 'GET',
                quietMillis: 50,
                data: ({term}) => ({search: term, customer_id: $('#customer').val()}),
                processResults: result => {
                    return { results: result.map(v => ({
                        id: v.id,
                        text: `#Invoice-${v.tid}  ${v.note}`, 
                        tax_rate: v.tax_rate * 1,
                        frx_rate: v.frx_rate * 2,
                    }))};
                }  
            }
        },
        projectSelect: {
            allowClear: true,
            ajax: {
                url: "{{ route('biller.projects.select') }}",
                dataType: 'json',
                type: 'POST',
                quietMillis: 50,
                data: ({term}) => ({search: term, customer_id: $('#customer').val()}),
                processResults: result => {
                    return { results: result.map(v => ({text: `#Project-${v.tid}  ${v.name}`, id: v.id }))};
                }      
            }
        },
    };

    const Form = {
        init() {
            $('#productsTbl th').css({paddingTop: '5px', paddingBottom: '5px'});
            $('label').css({margin: 0});

            $.ajaxSetup(config.ajax);
            $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
            // Load customers
            $('#customer').select2(config.customerSelect);
            $('#invoice').select2(config.invoiceSelect);
            $('#project').select2(config.projectSelect);

            $('#customer').change(Form.customerChange);
            $('#invoice').change(Form.invoiceChange);
            $('#project').change(Form.projectChange);
            $('#return_status').change(Form.returnStatus);
            $('form').on('change', '.check_all, .check_item', Form.checkRow);
            $('#amount').keyup(() => Form.calcTotal());
        },

        customerChange() {
            $('#invoice option:not(:eq(0))').remove();
            $('#project option:not(:eq(0))').remove();
            $('#productsTbl tbody tr').remove();
        },

        projectChange() {
            $('#invoice option:not(:eq(0))').remove();
            $('#productsTbl tbody tr').remove();
            if (this.value) {
                $('#productsTbl').removeClass('d-none');
                $('#return_status').val(1).change();
            } else {
                $('#productsTbl').addClass('d-none');
                $('#return_status').val('').change();
            }
        },

        invoiceChange() {
            $('#productsTbl tbody tr').remove();
            $('#return_status').val('');
            $('#frx_rate').attr('readonly', true).val(1);
            if (this.value) {
                const data = $(this).select2('data')[0];
                if (data && data.id) {
                    $(this).attr('tax_rate', data.tax_rate);
                    $(this).attr('frx_rate', data.frx_rate);
                    $('#tax_rate').attr('readonly', false).val(data.tax_rate);
                    if (data.frx_rate != 1) 
                        $('#frx_rate').attr('readonly', false).val(data.frx_rate);
                }
            } 
            Form.calcTotal();
        },

        returnStatus() {
            $('#productsTbl tbody tr').remove();
            if (this.value) {
                $('#productsTbl').removeClass('d-none');
                // fetch goods
                const url = "{{ route('biller.creditnotes.return_goods') }}";
                const params = {
                    customer_id: $('#customer').val(),
                    invoice_id: $('#invoice').val(),
                    project_id: $('#project').val(),
                }
                $.post(url, params, data => {
                    data.forEach((v) =>  $('#productsTbl tbody').append(Form.renderProducts(v)));
                });
            } else {
                $('#productsTbl').addClass('d-none');
            }
        },

        renderProducts(v) {
            return `
                <tr>
                    <td><input type="checkbox" class="check_item"></td>
                    <td>${v.sku || ''}</td>
                    <td>${v.name}</td>
                    <td>${v.unit || ''}</td>
                    <td><input type="number" min="0" step=".01" name="prod_qty[]" class="form-control qty" disabled/></td>
                    <input type="hidden" name="prod_id[]" value="${v.id}" disabled/>
                    <input type="hidden" name="prod_rate[]" value="${v.purchase_price}" disabled/>
                </tr>
            `;
        },

        checkRow() {
            if ($(this).is('.check_item')) {
                const row = $(this).parents('tr');
                if ($(this).prop('checked')) {
                    row.find('.qty').attr('disabled', false);
                    row.find(':hidden').attr('disabled', false);
                } else {
                    row.find('.qty').attr('disabled', true);
                    row.find(':hidden').attr('disabled', true);
                }
                
            } else {
                if ($(this).prop('checked')) {
                    $('#productsTbl tbody').find('.qty').each(function() { $(this).attr('disabled', false) });
                    $('#productsTbl tbody').find(':hidden').each(function() { $(this).attr('disabled', false) });
                    $('#productsTbl tbody').find('.check_item').prop('checked', true);
                } else {
                    $('#productsTbl tbody').find('.qty').each(function() { $(this).attr('disabled', true) });
                    $('#productsTbl tbody').find(':hidden').each(function() { $(this).attr('disabled', true) });
                    $('#productsTbl tbody').find('.check_item').prop('checked', false);
                }
            }
        },

        calcTotal() {
            const amount = accounting.unformat($('#amount').val());
            const taxRate = accounting.unformat($('#invoice').attr('tax_rate'));
            const frxRate = accounting.unformat($('#invoice').attr('frx_rate'));

            const total = amount;
            let taxable = amount / (1 + taxRate/100);
            let tax = total - taxable;
            if (taxRate == 0) {
                taxable = 0;
                tax = 0;
            }
            
            if (frxRate > 1) {
                $('#frx_amount').val(accounting.formatNumber(amount*frxRate));
                $('#frx_taxable').val(accounting.formatNumber(taxable*frxRate));
                $('#frx_total').val(accounting.formatNumber(total*frxRate));
                $('#frx_tax').val(accounting.formatNumber(tax*frxRate));
            }
            $('#taxable').val(accounting.formatNumber(taxable));
            $('#total').val(accounting.formatNumber(total));
            $('#tax').val(accounting.formatNumber(tax));
        },
    };

    $(Form.init);
</script>