<div class="tab-pane" id="tab3" role="tabpanel" aria-labelledby="base-tab3">
    <div class="row mt-1">
        <div class="col-md-6">
            <div class='form-group'>
                <label for="receivable_account">Accounts Receivable</label>
                <select name="ledger_id" id="ledger_id" class="custom-select">
                    <option value="">-- Select Subcategory Account --</option>
                    @foreach ($account->subledgers as $row)
                        <option value="{{ $row->id }}" {{ $row->id == @$customer->ledger_id? 'selected' : '' }}>
                            {{ $row->name }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class='form-group'>
                {{ Form::label('opening_balance', 'Opening Balance', ['class' => ' control-label']) }}
                {{ Form::text('open_balance', numberFormat(@$customer->open_balance), ['class' => 'form-control', 'id' => 'open_balance']) }}  
            </div>
        </div>
        <div class="col-md-2">
            <div class='form-group'>
                {{ Form::label('as_at_date', 'Balance As At Date',['class' => ' control-label']) }}
                {{ Form::text('open_balance_date', null, ['class' => 'form-control datepicker', 'id' => 'open_balance_date']) }}  
            </div>   
        </div>
        <div class="col-md-4">
            <div class='form-group'>
                {{ Form::label('exchange_rate', 'Currency Rate',['class' => ' control-label']) }}
                <div class="row no-gutters">
                    <div class="col-md-6">
                        <select class="custom-select currency_id" name="currency_id" id="currency_id" required>
                            @foreach ($currencies as $row)
                                <option value="{{ $row->id }}" rate="{{ +$row->rate }}">
                                    {{ $row->code }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        {{ Form::text('frx_rate', null, ['class' => 'form-control', 'id' => 'frx_rate', 'readonly']) }}  
                    </div>
                </div>
            </div>   
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class='form-group'>
                {{ Form::label('note', 'Note',['class' => 'control-label']) }}
                {{ Form::text('open_balance_note', null, ['class' => 'form-control', 'id' => 'open_balance_note']) }}  
            </div>  
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table id="invoicesTbl" class="table tfr my_stripe_single pb-1 text-center">
                    <thead>
                        <tr class="item_header bg-gradient-directional-blue white">
                            <th width="5%">#</th>
                            <th width="10%">Inv No.</th>
                            <th width="10%">Date</th>
                            <th width="10%">Due Date</th>
                            <th width="35%">Inv Description</th>
                            <th width="12%">Inv Amount</th>
                            <th width="12%">Amount Paid</th>                            
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- invoice row template -->
                        <tr class="d-none">
                            <td>1</td>
                            <td><input type="number" name="inv_no[]" class="form-control inv_no"></td>
                            <td><input type="text" name="inv_date[]" class="form-control inv_date datepicker"></td>
                            <td><input type="text" name="inv_due_date[]" class="form-control inv_due_date datepicker"></td>
                            <td><input type="text" name="inv_descr[]" class="form-control inv_descr"></td>
                            <td><input type="text" name="inv_amount[]" class="form-control inv_amount"></td>
                            <td><input type="text" name="inv_amountpaid[]" class="form-control inv_amountpaid"></td>
                            <td>
                                <div class="dropdown">
                                    <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        action
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <a class="dropdown-item add_row" href="javascript:"><i class="fa fa-plus"></i> Row</a>
                                        <a class="dropdown-item text-danger del_row" href="javascript:"><i class="fa fa-trash"></i> Remove</a>
                                    </div>
                                </div> 
                            </td>
                            <input type="hidden" name="invoice_id[]">
                        </tr>
                        <!-- end invoice row template -->

                        @if (@$customer)
                            @foreach ($customer->opening_balance_invoices as $i => $row)
                                <tr>
                                    <td>{{ $i+1 }}</td>
                                    <td><input type="number" name="inv_no[]" value="{{ $row->tid }}" class="form-control inv_no"></td>
                                    <td><input type="text" name="inv_date[]" value="{{ dateFormat($row->invoicedate) }}" class="form-control inv_date datepicker"></td>
                                    <td><input type="text" name="inv_due_date[]" value="{{ dateFormat($row->invoiceduedate) }}" class="form-control inv_due_date datepicker"></td>
                                    <td><input type="text" name="inv_descr[]" value="{{ $row->note }}" class="form-control inv_descr"></td>
                                    <td><input type="text" name="inv_amount[]" value="{{ numberFormat($row->total) }}" class="form-control inv_amount" {{ $row->is_allocated_opening_balance? 'readonly' : '' }}></td>
                                    <td><input type="text" name="inv_amountpaid[]" value="{{ numberFormat($row->amount_received) }}" class="form-control inv_amountpaid" {{ $row->is_allocated_opening_balance? 'readonly' : '' }}></td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                action
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <a class="dropdown-item add_row" href="javascript:"><i class="fa fa-plus"></i> Row</a>
                                                @if (!$row->is_allocated_opening_balance)
                                                    <a class="dropdown-item text-danger del_row" href="javascript:"><i class="fa fa-trash"></i> Remove</a>
                                                @endif
                                            </div>
                                        </div> 
                                    </td>
                                    <input type="hidden" name="invoice_id[]" value="{{ $row->id }}">
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>        
</div>
