<div class="form-group row">
    <div class="col-md-3">
        <div><label for="date">Date</label></div>
        {{ Form::text('date', null, ['class' => 'form-control datepicker', 'id' => 'date']) }}
    </div>
    
    <div class="col-md-3">
        <label for="amount">Amount</label>
        {{ Form::text('amount', null, ['class' => 'form-control', 'id' => 'amount']) }}
    </div>  

    <div class="col-md-6">
        <label for="supplier">Supplier</label>
        <select name="supplier_id" id="supplier" class="form-control" data-placeholder="Seach Supplier" required>
            <option value=""></option>
            @isset($debitnote)
                <option value="{{ $debitnote->supplier_id }}">{{ $debitnote->supplier->company }}</option>
            @endisset
        </select>                          
    </div>
</div>

<div class="form-group row">
    <div class="col-md-6">
        <label for="project">Project</label>
        <select name="project_id" id="project" class="form-control" data-placeholder="Search project">
            <option value=""></option>
            @isset($debitnote)
                <option value="{{ $debitnote->project_id }}" selected>
                    {{ $debitnote->project->title }}
                </option>
            @endisset
        </select>
    </div>
    <div class="col-md-4">
        <label for="invoice">Invoice</label>
        <select name="invoice_id" id="invoice" class="form-control" data-placeholder="Search Invoice">
            <option value=""></option>
            @isset($debitnote)
                <option value="{{ $debitnote->invoice_id }}" selected>
                    {{ $debitnote->invoice->notes }}
                </option>
            @endisset
        </select>
    </div>
    <div class="col-md-2">
        <label for="frx_rate">Exchange Rate</label>
        {{ Form::number('frx_rate', numberFormat(1), ['class' => 'form-control', 'step' => '0.01', 'id' => 'frx_rate', 'readonly']) }}
        <input type="hidden" name="tax_rate" id="tax_rate">
    </div>  
</div>

<div class="form-group row">
    <div class="col-md-12">
        <div><label for="note">Note</label></div>
        {{ Form::text('note', null, ['class' => 'form-control']) }}
    </div> 
</div>

<div class="form-group row">
    <div class="col-md-2">
        <label for="return_status">Status</label>
        <select id="return_status" class="custom-select">
            @foreach (['Without Goods', 'With Goods'] as $key => $value)
                <option value="{{ $key ?: null }}">
                    Return {{ $value }}
                </option>
            @endforeach
        </select>
    </div>
</div>

<div class="table-responsive">
    <table class="table tfr my_stripe_single d-none" id="productsTbl">
        <thead>
            <tr class="bg-gradient-directional-blue white">
                <th><input type="checkbox" class="check_all"></th>
                <th>SKU Code</th>
                <th>Item Description</th>
                <th>UoM</th>
                <th width="15%">Qty</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>

<div class="row">
    <div class="col-md-2 ml-auto">
        <label for="taxable" >Taxable</label>
        {{ Form::text('taxable', null, ['class' => 'form-control', 'id' => 'taxable', 'readonly']) }}
        
    </div>  
</div>
<div class="row">
    <div class="col-md-2 ml-auto">
        <label for="tax" >Tax</label>
        {{ Form::text('tax', null, ['class' => 'form-control', 'id' => 'tax', 'readonly']) }}
    </div>  
</div>
<div class="row">
    <div class="col-md-2 ml-auto">
        <label for="total" >Total</label>
        {{ Form::text('total', null, ['class' => 'form-control', 'id' => 'total', 'readonly']) }}
    </div> 
</div>
<input type="hidden" name="frx_amount" id='frx_amount'>
<input type="hidden" name="frx_taxable" id='frx_taxable'>
<input type="hidden" name="frx_tax" id='frx_tax'>
<input type="hidden" name="frx_total" id='frx_total'>

@section('after-scripts')
@include('focus.debitnotes.form_js')
@endsection
