<div class="form-group row">
    {{-- <div class="col-2">
        <label for="document_type">Document Type</label>
        <select name="document_type" id="document_type" class="form-control" data-placeholder="Choose Document" required>
            <option value="purchase_order">Purchase Order</option>
            <option value="direct_purchase">Direct Purchase</option>
        </select>
    </div>
    <div class="col-2">
        <label for="item_type">Item Type</label>
        <select name="item_type" class="form-control item-type" id="item-type">
            <option value="">Select Item Type</option>
            <option value="paper" {{ @$goodsreceivenote && $goodsreceivenote->item_type == 'paper'? 'selected' : '' }}>Paper</option>
            <option value="other_items" {{ @$goodsreceivenote && $goodsreceivenote->item_type == 'other_items'? 'selected' : '' }}>Other Items</option>
        </select>
    </div> --}}
    <div class="col-6">
        <label for="supplier">Supplier</label>
        <select id="supplier" class="form-control" data-placeholder="Choose Supplier">
            
           @isset($goodsreceivenote)
           @foreach ($suppliers as $row)
                <option value="{{ $row->id }}" {{ @$goodsreceivenote && $goodsreceivenote->supplier_id == $row->id? 'selected' : '' }}>
                    {{ $row->name }}
                </option>
            @endforeach
           @endisset
        </select>
        {{ Form::hidden('supplier_id', null, ['class' => 'form-control', 'id' => 'supplier_id']) }}
        {{ Form::hidden('tid', @$goodsreceivenote ? $goodsreceivenote->tid : $tid+1, ['class' => 'form-control', 'id' => 'tid', 'readonly']) }}
    </div>

    <div class="col-2">
        <label for="date" class="caption">Date</label>
        {{ Form::text('date', null, ['class' => 'form-control datepicker', 'id' => 'date', 'required']) }}
    </div>   
    <div class="col-2">
        <label for="dnote" class="caption">DNote No.</label>
        {{ Form::text('dnote', null, ['class' => 'form-control', 'id' => 'dnote', 'required']) }}
    </div>  
    <div class="col-2">
        <label for="tax" class="caption">TAX %</label>
        <select name="tax_rate" id="tax_rate" class="custom-select">
            @foreach ([0, 16, 8] as $val)
                <option value="{{ $val }}" {{ @$goodsreceivenote && $goodsreceivenote->tax_rate == $val? 'selected' : '' }}>
                    {{ $val? $val . '% VAT' : 'OFF' }}
                </option>
            @endforeach
        </select>
    </div>
    
</div> 

<div class="form-group row">  
      
    <div class="col-4">
        <label for="purchaseorder" class="caption">Supplier Order</label>
        <select name="purchaseorder_id" id="purchaseorder" class="form-control" data-placeholder="Choose Order">
            <option value=""></option>
            @isset($goodsreceivenote)
                <option value="{{ $goodsreceivenote->purchaseorder_id }}" selected>
                    {{ @$goodsreceivenote->purchaseorder->note }}
                </option>
            @endisset
        </select>
    </div> 
    
    <div class="col-2">
        <label for="receive_status" class="caption">Invoice Status</label>
        <select name="invoice_status" id="invoice_status" class="custom-select">
            @foreach (['without_invoice', 'with_invoice'] as $val)
                <option value="{{ $val }}">{{ ucfirst(str_replace('_', ' ', $val)) }}</option>
            @endforeach
        </select>
    </div>  
    <div class="col-2">
        <label for="invoice" class="caption">Invoice No.</label>
        {{ Form::text('invoice_no', null, ['class' => 'form-control', 'id' => 'invoice_no', 'disabled']) }}
    </div>  
    <div class="col-2">
        <label for="invoice_date" class="caption">Invoice Date</label>
        {{ Form::text('invoice_date', null, ['class' => 'form-control datepicker', 'id' => 'invoice_date', 'disabled']) }}
    </div>  
</div>

<div class="form-group row">
    <div class="col-12">
        <label for="note">Note</label>    
        {{ Form::text('note', null, ['class' => 'form-control', 'id' => 'note']) }}
    </div>
</div>

<div class="table-responsive">
    <table class="table tfr my_stripe_single text-center" id="productTbl">
        <thead>
            <tr class="bg-gradient-directional-blue white">
                <th></th>
                <th>#</th>
                <th>Product Description</th>
                <th>UoM</th>
                <th>Item Type</th>
                <th>Qty Ordered</th>
                <th>Qty Received</th>
                <th>Qty Due</th>
                <th width="12%">Qty</th>
                <th width="12%">SKU</th>
                <th width="12%">Warehouse</th>
                <th width="12%">Weight</th>
                {{-- <th width="12%">Ledger</th> --}}
            </tr>
        </thead>
        <tbody>
            @isset($goodsreceivenote)
                @php $grn = $goodsreceivenote @endphp
                @foreach ($grn->items as $i => $item)
                    @php 
                        $po_item = $item->purchaseorder_item;
                        if (!$po_item) continue;
                        $qty_due = $po_item->qty - $po_item->qty_received;
                        $qty_due = $qty_due > 0? +$qty_due : 0
                    @endphp
                    <tr>
                        <td></td>
                        <td>{{ $i+1 }}</td>
                        <td>{{ $po_item->name }}</td>
                        <td>{{ $po_item->uom }}</td>
                        <td>{{ $po_item->item_type }}</td>
                        <td class="qty_ordered">{{ +$po_item->qty }}</td>
                        <td class="qty_received">{{ +$po_item->qty_received }}</td>
                        <td class="qty_due">{{ $qty_due }}</td>
                        <td><input name="qty[]" value="{{ +$item->qty }}" origin="{{ +$item->qty }}" class="form-control qty" id="qty"></td>
                        <td><input name="sku[]" value="{{ $item->sku }}" origin="{{ $item->sku }}" class="form-control sku" id="sku"></td>
                        <td><select name="warehouse_id[]" id="warehouse" class="form-control warehouse">
                            <option value="0">Default</option>
                            @foreach ($warehouses as $warehouse)
                                <option value="{{$warehouse->id}}" {{$warehouse->id == @$item->warehouse_id ? 'selected' : ''}}>{{$warehouse->title}}</option>
                            @endforeach
                        </select> </td> 
                        <td><input name="weight[]" value="{{ +$item->weight }}" origin="{{ +$item->weight }}" class="form-control weight" id="weight"></td>
                        {{-- <td>
                            <select name="ledger_id[]" id="ledger_id" class="custom-select">
                                <option value="">-- Select Subcategory Account --</option>
                                @foreach ($account->subledgers as $row)
                                    <option value="{{ $row->id }}" {{ $row->id == @$item->ledger_id? 'selected' : '' }}>
                                        {{ $row->name }}
                                    </option>
                                @endforeach
                            </select>
                        </td> --}}
                        <input type="hidden" name="rate[]" value="{{ +$po_item->purchase_price }}" class="rate">
                        <input type="hidden" name="id[]" value="{{ $item->id }}">
                        <input type="hidden" class="item" name="item_type[]" value="{{$po_item->item_type }}">
                    </tr>
                @endforeach
            @endisset
        </tbody>   
        
    </table>
</div>

<div class="row">
    <div class="col-2 ml-auto">
        {{-- <label for="subtotal">Subtotal</label>     --}}
        {{ Form::hidden('subtotal', null, ['class' => 'form-control', 'id' => 'subtotal', 'readonly']) }}
    </div>
</div>
<div class="row">
    <div class="col-2 ml-auto">
        {{-- <label for="tax">Tax</label>     --}}
        {{ Form::hidden('tax', null, ['class' => 'form-control', 'id' => 'tax', 'readonly']) }}
    </div>
</div>
<div class="row">
    <div class="col-2 ml-auto">
        {{-- <label for="total">Total</label>     --}}
        {{ Form::hidden('total', null, ['class' => 'form-control', 'id' => 'total', 'readonly']) }}
    </div>
</div>
<div class="row mt-1">                       
    <div class="col-2 ml-auto">  
        {{ Form::submit(@$goodsreceivenote? 'Update' : 'Receive Goods', ['class' =>'btn btn-primary btn-lg']) }}
    </div>
</div>

@section('after-scripts')
@include('focus.goodsreceivenotes.form_js')
@endsection
