{{ Html::script('focus/js/select2.min.js') }}
{{ Html::script(mix('js/dataTable.js')) }}
<script>
    const config = {
        ajaxSetup: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
        select2: {allowClear: true},
        fetchLpo: (supplier_id) => {
            return $.ajax({
                url: "{{ route('biller.suppliers.purchaseorders') }}",
                type: 'POST',
                quietMillis: 50,
                data: {supplier_id, type: 'grn'},
            });
        },
        fetchLpoGoods: (purchaseorder_id) => {
            return $.ajax({
                url: "{{ route('biller.purchaseorders.goods') }}",
                type: 'POST',
                quietMillis: 50,
                data: {purchaseorder_id},
            });
        },
        fetchDirectGoods: (purchaseorder_id) => {
            return $.ajax({
                url: "{{ route('biller.purchases.goods') }}",
                type: 'POST',
                quietMillis: 50,
                data: {purchaseorder_id},
            });
        }
       
    };

    const Form = {
        grn: @json(@$goodsreceivenote),
        supplierUrl: "{{ route('biller.suppliers.select') }}",

        init() {
            $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
            //$('#supplier').select2(config.select2);
            $('#purchaseorder').select2(config.select2);
            $('#supplier').select2(this.select2Config(Form.supplierUrl, this.supplierData));

            // edit mode
            if (this.grn) {
                if (this.grn.date) $('#date').datepicker('setDate', new Date(this.grn.date));
                if (this.grn.invoice_date) $('#invoice_date').datepicker('setDate', new Date(this.grn.invoice_date));
                $('#supplier').attr('disabled', true);
                $('#item-type').attr('disabled', true);
                $('#document_type').attr('disabled', true);
                $('#purchaseorder').attr('disabled', true);
                if (this.grn.invoice_no) {
                    $('#invoice_status option:eq(0)').remove();
                    $('#invoice_no').attr('disabled', false);
                    $('#invoice_date').attr('disabled', false);
                } else {
                    $('#invoice_status option:eq(1)').remove();
                }
                $('#productTbl tbody tr').each(function() {
                    if (!$(this).find('.item').val()) return;
                    const item_type = $(this).find('.item').val();
                    if(item_type == 'other_items' || item_type == null){
                        $(this).find('.sku').attr('readonly', true);
                        $(this).find('.weight').attr('readonly', true);
                        $(this).find('.warehouse').attr('readonly', true);
                        // $(this).find('.ledger').attr('readonly', true);
                    }
                    
                });
            } 

            $('#supplier').change(this.supplierChange);
            $('#purchaseorder').change(this.purchaseorderChange);
            $('#tax_rate').change(() => Form.columnTotals());
            $('#invoice_status').change(this.invoiceStatusChange);
            $('#document_type').change(this.documentChange);
            $('#productTbl').on('change', '.qty', this.onQtyChange);
            $('#productTbl').on('change', '.check', this.checkChange);
            $('#supplier').change(function() {
                const name = $('#supplier option:selected').text().split(' : ')[0];
                const [id, taxId] = $(this).val().split('-');
                // console.log(taxId);
                $('#taxid').val(taxId);
                $('#supplier_id').val(id);
                
                // $('#supplier').val(name);
            });
            // $('#item-type').change(this.itemChange);
            this.columnTotals();
        },

        invoiceStatusChange() {
            const el = $(this);
            if (el.val() == 'with_invoice') {
                $('#invoice_no').val('').attr({'disabled': false, 'required': true});
                $('#invoice_date').val('').attr({'disabled': false, 'required': true});
            } else {
                $('#invoice_no').val('').attr({'disabled': true, 'required': false});
                $('#invoice_date').val('').attr({'disabled': true, 'required': false});
            }
        },
        documentChange(){
            $('#supplier').val('');
            // console.log($('#item-type').val());
        },
        checkChange() {
            const el = $(this);
            const row = el.parents('tr:first');
            if (el.is('.check:checked')) {
                row.find('.qty').attr('disabled', false);
                row.find('.warehouse').attr('disabled', false);
                // row.find('.ledger').attr('disabled', false);
                row.find('.sku').attr('disabled', false);
                row.find('.weight').attr('disabled', false);
                const item_type = row.find('.item').val();
                if(item_type == 'other_items' ){
                    // console.log(item_type);
                    row.find('.sku').attr('readonly', true);
                    row.find('.weight').attr('readonly', true);
                    row.find('.warehouse').attr('readonly', true);
                    // row.find('.ledger').attr('readonly', true);
                }
                // else if(){
                //     console.log(item_type);
                //     row.find('.sku').attr('readonly', true);
                //     row.find('.weight').attr('readonly', true);
                //     row.find('.warehouse').attr('readonly', true);
                // }
            }else{
                row.find('.qty').attr('disabled', true);
                row.find('.warehouse').attr('disabled', true);
                // row.find('.ledger').attr('disabled', true);
                row.find('.sku').attr('disabled', true);
                row.find('.weight').attr('disabled', true);
            }
        },
        // itemChange(){
        //     if ($(this).val() == 'paper') {
                
        //         $('.sku_th').removeClass('d-none');
        //         $('#productTbl tbody tr').each(function() {
        //             const row = $(this);
        //             const td = row.find('.sku_td').val();
                    
                    
        //         });
        //         }
        // },
        select2Config(url, callback) {
            return {
                ajax: {
                    url,
                    dataType: 'json',
                    type: 'POST',
                    quietMillis: 50,
                    data: ({term}) => ({q: term, keyword: term, item_type: $('#item-type').val()}),
                    processResults: callback
                }
            }
        },
        supplierData(data) {
            return {results: data.map(v => ({id: v.id+'-'+v.taxid, text: v.name+' : '+v.email}))};
        },

        supplierChange() {
            const doc = $('#document_type').val();
           // console.log(doc);
            $('#purchaseorder option:not(:eq(0))').remove();
            $('#productTbl tbody').html('');
            const el = $(this);
            if (el.val()) {
                config
                .fetchLpo(el.val(), doc)
                .done(data => {
                    data.forEach(v => {
                        let tid = `${v.tid}`.length < 4? `000${v.tid}`.slice(-4) : v.tid;
                        $('#purchaseorder').append(`<option value="${v.id}">${tid} - ${v.note}</option>`);
                    });
                    $('#purchaseorder').change();
                });
            }
        },

        purchaseorderChange() {
            const el = $(this);
            $('#productTbl tbody').html('');
            if (!el.val()) return;
            config.fetchLpoGoods(el.val()).done(data => {
                data.forEach((v,i) => {
                    $('#productTbl tbody').append(Form.productRow(v,i));
                });
            });
            
        },

        productRow(v,i) {
            let received = accounting.formatNumber(v.qty_received);
            let due = v.qty - v.qty_received;
            let balance = accounting.formatNumber(due > 0? due : 0);
            return `
                <tr>
                    <td><input type="checkbox" id="qty" class="check"></td>    
                    <td>${i+1}</td>    
                    <td>${v.name}</td>    
                    <td>${v.code}</td>    
                    <td>${v.item_type}</td>    
                    <td class="qty_ordered">${accounting.formatNumber(v.qty)}</td>    
                    <td class="qty_received">${received}</td>    
                    <td class="qty_due">${balance}</td>    
                    <td><input name="qty[]" id="qty" class="form-control qty" disabled></td> 
                    <td><input name="sku[]" id="sku" class="form-control sku" value="0" disabled></td>
                    <td><select name="warehouse_id[]" id="warehouse" class="form-control warehouse" disabled>
                        <option value="0">Default</option>
                        @foreach ($warehouses as $warehouse)
                            <option value="{{$warehouse->id}}">{{$warehouse->title}}</option>
                        @endforeach
                    </select> </td>   
                    <td><input name="weight[]" id="weight" class="form-control weight" value="0" disabled></td>  
                         
                    <input type="hidden" name="purchaseorder_item_id[]" value="${v.id}">
                    <input type="hidden" name="rate[]" value="${parseFloat(v.purchase_price)}" class="rate">
                    <input type="hidden" name="item_id[]" value="${v.product_id}">
                    <input type="hidden" class="item" name="item_type[]" value="${v.item_type}">
                </tr>
            `;
        },
        purchaseProductRow(v,i) {
            let received = accounting.formatNumber(v.qty_received);
            let due = v.qty - v.qty_received;
            let balance = accounting.formatNumber(due > 0? due : 0);
            return `
                <tr>
                    <td>${i+1}</td>    
                    <td>${v.name}</td>    
                    <td>${v.uom}</td>    
                    <td class="qty_ordered">${accounting.formatNumber(v.qty)}</td>    
                    <td class="qty_received">${received}</td>    
                    <td class="qty_due">${balance}</td>    
                    <td><input name="qty[]" id="qty" class="form-control qty"></td>  
                    <td class="d-none sku_td"><input name="sku[]" id="sku" class="form-control sku"></td>   
                    <input type="hidden" name="purchaseorder_item_id[]" value="${v.id}">
                    <input type="hidden" name="rate[]" value="${parseFloat(v.purchase_price)}" class="rate">
                    <input type="hidden" name="item_id[]" value="${v.product_id}">
                </tr>
            `;
        },
        paperProductRow(v,i) {
            let received = accounting.formatNumber(v.qty_received);
            let due = v.qty - v.qty_received;
            let balance = accounting.formatNumber(due > 0? due : 0);
            return `
                <tr>
                    <td>${i+1}</td>    
                    <td>${v.name}</td>    
                    <td>${v.uom}</td>    
                    <td class="qty_ordered">${accounting.formatNumber(v.qty)}</td>    
                    <td class="qty_received">${received}</td>    
                    <td class="qty_due">${balance}</td>    
                    <td><input name="qty[]" id="qty" class="form-control qty"></td>  
                    <td><input name="sku[]" id="sku" class="form-control sku"></td>   
                    <input type="hidden" name="purchaseorder_item_id[]" value="${v.id}">
                    <input type="hidden" name="rate[]" value="${parseFloat(v.purchase_price)}" class="rate">
                    <input type="hidden" name="item_id[]" value="${v.product_id}">
                </tr>
            `;
        },

        onQtyChange() {
            let qty = accounting.unformat(this.value);

            // limit qty on goods received
            let row = $(this).parents('tr');
            let qtyDue = accounting.unformat(row.find('.qty_due').text());
            let qtyOrdered = accounting.unformat(row.find('.qty_ordered').text());
            let qtyReceived = accounting.unformat(row.find('.qty_received').text());
            if (!Form.grn) {
                if (qty > qtyDue) qty = qtyDue;
            } else {
                let limit = qty;
                let originQty = accounting.unformat($(this).attr('origin'));
                if (qtyDue && qtyReceived < qtyOrdered) {
                    limit = originQty + qtyDue;
                } else {
                    if (qtyReceived > qtyOrdered) {
                        if (originQty < qtyReceived) limit = originQty - (qtyOrdered - qtyReceived);
                        if (originQty == qtyReceived) limit = qtyOrdered;
                    } else {
                        limit = qtyOrdered;
                    }
                }
                if (qty > limit) qty = limit;
            }

            this.value = accounting.formatNumber(qty);
            Form.columnTotals();
        },

        columnTotals() {
            subtotal = 0;
            total = 0;
            const tax_rate = 1 + $('#tax_rate').val() / 100;
            $('#productTbl tbody tr').each(function() {
                const row = $(this);
                const qty = accounting.unformat(row.find('.qty').val());
                const rate = accounting.unformat(row.find('.rate').val());
                subtotal += qty * rate;
                total += qty * rate * tax_rate;
               
            });
            $('#subtotal').val(accounting.formatNumber(subtotal));
            $('#tax').val(accounting.formatNumber(total - subtotal));
            $('#total').val(accounting.formatNumber(total));
            
        },
    }

    $(() => Form.init());
</script>
