<div class='form-group row'>
    <div class='col-3'>
        {{ Form::label( 'name', 'Customer Name',['class' => 'control-label']) }}
        {{-- {{ Form::text('name', null, ['class' => 'form-control round', 'placeholder' => 'Customer Name']) }} --}}
        <select name="customer_id" id="customer" class="form-control" data-placeholder="Search Customer">
            @foreach ($customers as $customer)
                <option value="{{ $customer->id }}" {{$customer->id == @$jobcards->customer_id ? 'selected' : ''}}>{{ $customer->company }}</option>
            @endforeach
        </select>
    </div>
    <div class='col-3'>
        {{ Form::label( 'jobcard_no', 'Job Card Number',['class' => 'control-label']) }}
        {{ Form::text('jobcard_no', @$jobcard_number, ['class' => 'form-control round', 'placeholder' => 'Job Card Number', 'readonly']) }}
    </div>
    <div class='col-3'>
        {{ Form::label( 'jobcard_date', 'Job Card Date',['class' => 'control-label']) }}
        {{ Form::text('jobcard_date', null, ['class' => 'form-control round datepicker', 'placeholder' => '']) }}
    </div>
    <div class='col-3'>
        {{ Form::label( 'type', 'Type',['class' => 'control-label']) }}
        {{-- {{ Form::text('type', null, ['class' => 'form-control round', 'placeholder' => 'Type']) }} --}}
        <select name="type" id="type" class="form-control round">
            <option value="">---Select Type---</option>
            @foreach (['RSC', 'DIE'] as $item)
                <option value="{{$item}}" {{$item == @$jobcards->type ? 'selected' : ''}}>{{$item}}</option>
            @endforeach
        </select>
    </div>
</div>
<div class='form-group row'>
    <div class='col-2'>
        {{ Form::label( 'total_board', 'Total B/M Board',['class' => 'control-label']) }}
        {{ Form::text('total_board', null, ['class' => 'form-control round', 'placeholder' => '0.00', 'id'=> 'total_board']) }}
        
        
        {{-- {{ Form::hidden('total_length', null, ['id'=> 'total_length']) }} --}}
        {{ Form::hidden('flap', null, ['id'=> 'flap']) }}
        {{-- <input type="hidden" name="total_width" id="total_width">
        <input type="hidden" class="reel-size" name="total_reel_size" id="reel_size">
        <input type="hidden" name="total_length" id="total_length">
        <input type="hidden" name="flap" id="flap"> --}}
    </div>
    <div class='col-2'>
        {{ Form::label( 'qty', 'Total Qty',['class' => 'control-label']) }}
        {{ Form::text('total_qty', null, ['class' => 'form-control round', 'placeholder' => '0.00','id'=> 'total_qty']) }}
    </div>
    <div class='col-2'>
        {{ Form::label( 'flute', 'Flute',['class' => 'control-label']) }}
        <select name="flute[]" id="flute" class="form-control round select-box" data-placeholder="Select Flute" multiple>
            <option value="">Select Flute</option>
            @foreach (['b','c','e'] as $val)
                <option value="{{$val}}" {{in_array($val, @$jobcards->flute ?: []) ? 'selected' : '' }}>{{ ucfirst($val) }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-6">
        {{ Form::label( 'description', 'Description',['class' => 'control-label']) }}
        {{ Form::text('description', null, ['class' => 'form-control round', 'placeholder' => 'description']) }}
    </div>
    
    
</div>
<p>Board Details</p>
<hr>
<div class='form-group row'>
    
    <div class='col-2'>
        {{ Form::label( 'length', 'Length',['class' => 'control-label']) }}
        {{ Form::text('length', null, ['class' => 'form-control round', 'placeholder' => '0.00', 'id'=> 'lenght']) }}
    </div>
    <div class='col-2'>
        {{ Form::label( 'width', 'Width',['class' => 'control-label']) }}
        {{ Form::text('width', null, ['class' => 'form-control round', 'placeholder' => '0.00', 'id'=> 'width']) }}
    </div>
    <div class='col-2'>
        {{ Form::label( 'height', 'Height',['class' => 'control-label']) }}
        {{ Form::text('height', null, ['class' => 'form-control round', 'placeholder' => '0.00', 'id'=> 'height']) }}
    </div>
    <div class="col-2">
        {{ Form::label( 'no_outs', 'Total Lenght',['class' => 'control-label']) }}
        {{ Form::text('total_length', null, ['class' => 'form-control round','id'=> 'total_length']) }}
    </div>
    <div class="col-2">
        {{ Form::label( 'no_outs', 'Total Width',['class' => 'control-label']) }}
        {{ Form::text('total_width', null, ['class' => 'form-control round','id'=> 'total_width']) }}
    </div>
    <div class='col-2'>
        {{ Form::label( 'no_outs', 'No. of Outs',['class' => 'control-label']) }}
        {{ Form::text('no_of_outs', null, ['class' => 'form-control round', 'placeholder' => '0.00', 'id'=> 'no_of_out']) }}
    </div>
   
   
    
</div>
<p>Box Details</p>
<hr>
<div class="form-group row">
    <div class='col-2'>
        {{ Form::label( 'no_of_chops', 'No. of Chops',['class' => 'control-label']) }}
        {{ Form::text('no_of_chops', null, ['class' => 'form-control round', 'placeholder' => '0.00','id'=> 'no_of_chop']) }}
    </div>
    <div class="col-2">
        {{ Form::label( 'total_reel_size', 'Reel Size',['class' => 'control-label']) }}
        {{ Form::text('total_reel_size', null, ['class' => 'form-control round reel-size', 'placeholder' => '0.00','id'=> 'reel_size']) }}
    </div>
    <div class='col-2'>
        {{ Form::label( 'cortons_bundle', 'Cartons/Bundle',['class' => 'control-label']) }}
        {{ Form::text('cortons_bundle', null, ['class' => 'form-control round', 'placeholder' => '']) }}
    </div>
    <div class='col-2'>
        {{ Form::label( 'flute_type', 'Ply Value',['class' => 'control-label']) }}
        <select name="flute_type" id="flute_type" class="form-control round">
            <option value="">Select Ply Value</option>
            @foreach (['three','five'] as $val)
                <option value="{{$val}}" {{@$jobcards->flute_type == $val? 'selected' : ''}}>{{ ucfirst($val) }}</option>
            @endforeach
        </select>
    </div>
    <div class='col-2'>
        {{ Form::label( 'mfg_joint', 'Mfg Joint',['class' => 'control-label']) }}
        <select name="mfg_joint" id="mfg_joint" class="form-control round">
            <option value="">Select Mfg Joint</option>
            @foreach (['stitching','strapping'] as $val)
                <option value="{{$val}}" {{@$jobcards->mfg_joint == $val? 'selected' : ''}}>{{ ucfirst($val) }}</option>
            @endforeach
        </select>
    </div>
    <div class='col-2'>
        {{ Form::label( 'die_no', 'Die No.',['class' => 'control-label']) }}
        {{ Form::text('die_no', null, ['class' => 'form-control round', 'placeholder' => '0.00']) }}
    </div>
    
   
</div>
<div class="form-group row">
    <div class='col-2'>
        {{ Form::label( 'die_cut_outs', 'DieCut Outs',['class' => 'control-label']) }}
        {{ Form::text('die_cut_outs', null, ['class' => 'form-control round', 'placeholder' => '0.00']) }}
    </div>
    <div class='col-2'>
        {{ Form::label( 'sheet_weight', 'Sheet Weight',['class' => 'control-label']) }}
        {{ Form::text('sheet_weight', null, ['class' => 'form-control round', 'placeholder' => '0.00', 'readonly', 'id'=>'sheet_weight']) }}
    </div>
    <div class="col-6">
        {{-- {{dd($jobcards->processes->pluck('process_id'))}} --}}
        {{ Form::label( 'process', 'Select Processes',['class' => 'control-label']) }}
        <select class="form-control select-box" name="process_id[]" id="process" data-placeholder="Search Process"  multiple>
            @foreach($processes as $process)
                <option value="{{ $process['id'] }}" {{ in_array($process['id'], (@$jobcards->processes ? @$jobcards->processes->pluck('process_id')->toArray() : []))? 'selected' : '' }} selected>
                    {{ $process->process_name }}
                </option>
            @endforeach
        </select>
    </div>
</div>
<div class="form-group row">
    <div class="col-6">
        {{-- {{dd($jobcards->processes->pluck('process_id'))}} --}}
        {{ Form::label( 'process', 'Attach Print & Designs',['class' => 'control-label']) }}
        <select class="form-control select-box" name="design_id[]" id="design" data-placeholder="Search Print & Design"  multiple>
            @foreach($designs as $design)
                <option value="{{ $design['id'] }}" {{ in_array($design['id'], (@$jobcards->attachments ? @$jobcards->attachments->pluck('design_id')->toArray() : []))? 'selected' : '' }}>
                    {{ $design->description }}
                </option>
            @endforeach
        </select>
    </div>
</div>
@include('focus.jobcards.partials.pattern-three')
@include('focus.jobcards.partials.creasing-pattern')

