@extends ('core.layouts.app')

@section ('title', 'Job Card Management')

@section('page-header')
    <h1>Job Card Management</h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h4 class="content-header-title mb-0">Job Card Management</h4>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        <div class="media-body media-right text-right">
                            @include('focus.jobcards.partials.jobcards-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card" id="filters">
                            <div class="card-header">
                                <div class="form-group row">
                                    <div class='col-3'>
                                        {{ Form::label( 'name', 'Customer Name',['class' => 'control-label']) }}
                                        {{-- {{ Form::text('name', null, ['class' => 'form-control round', 'placeholder' => 'Customer Name']) }} --}}
                                        <select name="customer_id" id="customer" class="form-control" data-placeholder="Search Customer">
                                            @foreach ($customers as $customer)
                                                <option value="{{ $customer->id }}">{{ $customer->company }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-4">
                                        <label for="filter">Filter Criteria</label>    
                                        <select name="job_status" id="status_filter" class="form-control">
                                            <option value="">---Select Job Status---</option>                         
                                            @foreach (['pending','inprogress','onhold','complete'] as $item)
                                                <option value="{{$item}}">{{ucfirst($item)}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="card-content">

                                <div class="card-body">
                                    <table id="jobcards-table"
                                           class="table table-striped table-bordered zero-configuration" cellspacing="0"
                                           width="100%">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Customer Name</th>
                                            <th>Job Card Number</th>
                                            <th>JC Date</th>
                                            <th>Type</th>
                                            <th>Description</th>
                                            <th>Bom</th>
                                            <th>Approval Status</th>
                                            <th>Job Status</th>
                                            <th>{{ trans('labels.general.actions') }}</th>
                                        </tr>
                                        </thead>


                                        <tbody>
                                        <tr>
                                            <td colspan="100%" class="text-center text-success font-large-1"><i
                                                        class="fa fa-spinner spinner"></i></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    {{-- For DataTables --}}
    {{ Html::script(mix('js/dataTable.js')) }}
    {{ Html::script('focus/js/select2.min.js') }}
    {{-- <script>
        $(function () {
            setTimeout(function () {
                draw_data()
            }, {{config('master.delay')}});
        });

        function draw_data() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            var dataTable = $('#jobcards-table').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                language: {
                    @lang('datatable.strings')
                },
                ajax: {
                    url: '{{ route("biller.jobcards.get") }}',
                    type: 'post'
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    {data: 'name', name: 'name'},
                    {data: 'jobcard_no', name: 'jobcard_no'},
                    {data: 'jobcard_date', name: 'jobcard_date'},
                    {data: 'type', name: 'type'},
                    {data: 'description', name: 'description'},
                    {data: 'bom_name', name: 'bom_name'},
                    {data: 'status', name: 'status'},
                    {data: 'job_status', name: 'job_status'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv','excel','pdf']
            });
            $('#jobcards-table_wrapper').removeClass('form-inline');

        }
    </script> --}}
   <script>
    const config = {
        ajaxSetup: {headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" }},
        datepicker: {format: "{{ config('core.user_date_format') }}", autoHide: true}
    };

    const Index = {
        customers: @json($customers),

        init(config) {
            $.ajaxSetup(config.ajaxSetup);
            $('.datepicker').datepicker(config.datepicker).datepicker('setDate', new Date());
            $('#customer').select2({allowClear: true}).val('').trigger('change');

            $('#filters').on('change', '#status_filter, #customer', this.filterCriteriaChange);
            this.drawDataTable();
        },

        filterCriteriaChange() {
            $('#jobcards-table').DataTable().destroy();
            return Index.drawDataTable({
                job_status: $('#status_filter').val(),
                customer_id: $('#customer').val()
            });   
        },

        drawDataTable(params={}) {
            $('#jobcards-table').dataTable({
                processing: true,
                responsive: true,
                stateSave: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: "{{ route('biller.jobcards.get') }}",
                    type: 'POST',
                    data: {
                        ...params,
                    },
                    dataSrc: ({data}) => {
                        $('#amount_total').val('');
                        if (data.length) $('#amount_total').val(data[0].sum_total);                            
                        return data;
                    },
                },
                columns: [{
                        data: 'DT_Row_Index',
                        name: 'id'
                    },
                    ...[
                        'name', 'jobcard_no', 'jobcard_date', 'type', 'description', 'bom_name', 'status', 'job_status'
                    ].map(v => ({data: v, name: v})),
                    {
                        data: 'actions',
                        name: 'actions',
                        searchable: false,
                        sortable: false
                    }
                ],
                columnDefs: [
                    { type: "custom-number-sort", targets: 5 },
                    { type: "custom-date-sort", targets: [1,6] }
                ],
                order:[[0, 'desc']],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print'],
            });
        }
    };

    $(() => Index.init(config));
</script>
@endsection
