@extends ('core.layouts.app')

@section ('title', 'Job Card Management' . ' | ' . 'View')

@section('page-header')
    <h1>
        Job Card Management
        <small>View</small>
    </h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h3 class="content-header-title mb-0">View</h3>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        <div class="media-body media-right text-right">
                            @include('focus.jobcards.partials.jobcards-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                @php
                                    $job = $jobcard;
                                    $valid_token = token_validator('', 'jo' . $job->id, true);
                                    $link = route('biller.print_jobcard', [$job->id, 12, $valid_token, 1]);
                                @endphp
                                <a href="{{ $link }}" class="btn btn-purple btn-sm" target="_blank">
                                    <i class="fa fa-print" aria-hidden="true"></i> Print
                                </a>
                                <a href="#" data-toggle="modal" data-target="#AttachModal" class="btn btn-success btn-sm">
                                    <i class="fa fa-pencil" aria-hidden="true"></i> Attach Bom
                                </a>
                                <a href="#" class="btn btn-warning btn-sm mr-1" data-toggle="modal" data-target="#statusModal">
                                    <i class="fa fa-pencil" aria-hidden="true"></i>Approval Status
                                </a>
                                @if ($jobcard->status == 'approved')
                                <a href="#" class="btn btn-primary btn-sm mr-1" data-toggle="modal" data-target="#jobstatusModal">
                                    <i class="fa fa-pencil" aria-hidden="true"></i>Job Status
                                </a>
                                @endif
                                <div class='form-group row hide_picture mt-2'>
                                    {{-- {{ Form::label( 'signature', trans('hrms.signature'),['class' => 'col-lg-2 control-label']) }} --}}
                                   {{-- <form action="{{route('biller.jobcards.attach_design')}}" method="POST"> --}}
                                    {{ Form::open(['route' => 'biller.jobcards.attach_design', 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'post','files' => true, 'id' => 'create-hrm']) }}
                                        @csrf
                                        <div class='col-4'>
                                            {!! Form::file('design', array('class'=>'input' )) !!}  @if(@$jobcard->id)
                                                <small>{{trans('hrms.blank_field')}}</small>
                                            @endif
                                            <input type="hidden" name="id" value="{{$jobcard->id}}">
                                        </div>
                                       <div class="col-4 mt-1">
                                        <button type="submit" class="btn btn-sm btn-primary">Attach</button>
                                       </div>
                                    {{ Form::close() }}
                                    {{-- </form> --}}
                                    <div class="">
                                        {{-- {{dd(asset('storage/app/public/img/jobcard/'.$jobcard->design))}} --}}
                                        @if ($jobcard->design != NULL)
                                        <img class=""  width="450" height="250"
                                        src="{{ asset('storage/img/jobcard/'.$jobcard->design) }}" alt="Image">
                                        @else
                                        <img class="media-object img-xl m-1 border"
                                        src="{{ asset('default/default.jpg') }}" alt="Image">
                                        @endif
                                    </div>
                                </div>
                                
                            </div>

                            <div class="card-content">
                                

                                {{-- <div class="card-body">


                                    <div class="form-group row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Customer Name</h4>
                                            <h5><b>{{@$jobcard->customer['company']}}</b></h5>
                                        </div>
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Job Card Number</h4>
                                            <h5><b>{{$jobcard['jobcard_no']}}</b></h5>
                                        </div>
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Job Card Date</h4>
                                            <h5><b>{{dateFormat($jobcard['jobcard_date'])}}</b></h5>
                                        </div>
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Type</h4>
                                            <h5><b>{{$jobcard['type']}}</b></h5>
                                        </div>
                
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Total B/M Board</h4>
                                            <h5><b>{{numberFormat($jobcard['total_board'])}}</b></h5>
                                        </div>
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Total Qty</h4>
                                            <h5><b>{{numberFormat($jobcard['total_qty'])}}</b></h5>
                                        </div>
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Flute</h4>
                                            <h5><b>{{ucfirst($jobcard['flute'])}}</b></h5>
                                        </div>
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Description</h4>
                                            <h5><b>{{$jobcard['description']}}</b></h5>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>No of Outs</h4>
                                            <h5><b>{{numberFormat($jobcard['no_of_outs'])}}</b></h5>
                                        </div>
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>No of Chops</h4>
                                            <h5><b>{{numberFormat($jobcard['no_of_chops'])}}</b></h5>
                                        </div>
                                        <div class="col-2 border-blue-grey border-lighten-5  p-1">
                                            <h4>Length</h4>
                                            <h5><b>{{numberFormat($jobcard['length'])}}</b></h5>
                                        </div>
                                        <div class="col-2 border-blue-grey border-lighten-5  p-1">
                                            <h4>Width</h4>
                                            <h5><b>{{numberFormat($jobcard['width'])}}</b></h5>
                                        </div>
                                        <div class="col-2 border-blue-grey border-lighten-5  p-1">
                                            <h4>Height</h4>
                                            <h5><b>{{numberFormat($jobcard['height'])}}</b></h5>
                                        </div>
                                    </div>
                                    <p>BOX Details</p>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Cartons/Bundle</h4>
                                            <h5><b>{{$jobcard['cortons_bundle']}}</b></h5>
                                        </div>
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <h4>Mfg Joint</h4>
                                            <h5><b>{{$jobcard['mfg_joint']}}</b></h5>
                                        </div>
                                        <div class="col-2 border-blue-grey border-lighten-5  p-1">
                                            <h4>Die No</h4>
                                            <h5><b>{{numberFormat($jobcard['die_no'])}}</b></h5>
                                        </div>
                                        <div class="col-2 border-blue-grey border-lighten-5  p-1">
                                            <h4>Diecut Outs</h4>
                                            <h5><b>{{numberFormat($jobcard['die_cut_outs'])}}</b></h5>
                                        </div>
                                        <div class="col-2 border-blue-grey border-lighten-5  p-1">
                                            <h4>Sheet Weight (g)</h4>
                                            <h5><b>{{numberFormat($jobcard['sheet_weight'])}}</b></h5>
                                        </div>
                                    </div>


                                </div> --}}
                                <div class="card">
                                    <table class="table table-striped table-bordered zero-configuration">
                                        <tr>
                                            <td>
                                                <table class="mt-1">
                                                    <thead>
                                                        <tr>
                                                            <th>
                                                                Job Card Number:
                                                            </th>
                                                            <td class="tds">
                                                                {{ $jobcard->jobcard_no }}
                                                            </td>
                                                        </tr>
                                                    </thead>
                                                    
                                                </table>
                                            </td>
                                            <td class="">
                                                <table class="table table-striped table-bordered zero-configuration">
                                                    <thead>
                                                        <tr>
                                                            <td width="20%">JC Date</td>
                                                            <td width="20%">
                                                                {{ $jobcard->jobcard_date }}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td width="20%">Type</td>
                                                            <td width="20%">
                                                                {{ $jobcard->type }}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td width="20%">Total B/M Board</td>
                                                            <td width="20%">
                                                                {{ NumberFormat($jobcard->total_board) }}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td width="20%">Total Qty</td>
                                                            <td width="20%">
                                                                {{ NumberFormat($jobcard->total_qty) }}
                                                            </td>
                                                        </tr>
                                                    </thead>
                                            </table>
                                            </td>
                                        </tr>
                                    </table>
                                    
                                    <table class="table table-striped table-bordered zero-configuration" width="50%">
                                        <tr>
                                            <th>
                                                Customer Name:
                                            </th>
                                            <td class="tds">
                                                {{ @$jobcard->customer->company }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>
                                                Description:
                                            </th>
                                            <td class="tds">
                                                {{ $jobcard->description }}
                                            </td>
                                        </tr>
                                    </table>
                                    {{-- <table class="doc-table">
                                        <tr>
                                            <td class="doc-title-td">
                                                <span class='doc-title'>
                                                    
                                                </span>				
                                            </td>
                                        </tr>
                                    </table><br> --}}
                                    <table class="table table-striped table-bordered zero-configuration">
                                        <tr>
                                            <td>
                                                <table>
                                                    <tr>
                                                        <td width="100%">
                                                            <table>
                                                                <thead>
                                                                    <tr>
                                                                        <td class="borders">Length</td>
                                                                        <td class="borders">Width</td>
                                                                        <td class="borders">Height</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="borders">{{ NumberFormat($jobcard->length) }}</td>
                                                                        <td class="borders">{{ NumberFormat($jobcard->width) }}</td>
                                                                        <td class="borders">{{ NumberFormat($jobcard->height) }}</td>
                                                                    </tr>
                                                                </thead>
                                                                
                                                                
                                                                
                                                            </table>
                                                            
                                                        </td>
                                                        <td width="50%">
                                                            <table class="table table-striped table-bordered zero-configuration float-right">
                                                                <thead>
                                                                    <tr>
                                                                        <td>Flute</td>
                                                                        <td>
                                                                            {{ $jobcard->flute }}
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>No. of Outs</td>
                                                                        <td>
                                                                            {{ NumberFormat($jobcard->no_of_outs) }}
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>No of Chops</td>
                                                                        <td>
                                                                            {{ NumberFormat($jobcard->no_of_chops) }}
                                                                        </td>
                                                                    </tr>
                                                                </thead>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                                {{-- <table class="doc-table">
                                                    <tr>
                                                        <td class="doc-title-td">
                                                            <span class='doc-title'>
                                                                <h1>Hello</h1>
                                                            </span>				
                                                        </td>
                                                    </tr>
                                                </table> --}}
                                            </td>
                                            
                                            <td width="5%">&nbsp;</td>
                                            <td width="50%">
                                                <h4>Paper Requirements</h4>
                                                <table class="table table-striped table-bordered zero-configuration">
                                                    <thead>
                                                        <tr>
                                                            <td></td>
                                                            <td>Reel Size</td>
                                                            <td colspan="2">GSM</td>
                                                            <td>Meters</td>
                                                            <td>Tons</td>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($jobcard->items as $item)
                                                            <tr>
                                                                <td class="borders">{{$item->liner_name}}</td>
                                                                <td class="borders">{{NumberFormat($item->reel_size)}}</td>
                                                                <td class="borders">
                                                                    {{NumberFormat($item->gsm_value)}}
                                                                </td>
                                                                <td class="borders">{{$item->kraft_liner}}</td>
                                                                <td class="borders">{{NumberFormat($item->meters)}}</td>
                                                                <td class="borders">{{$item->tones}}</td>
                                                            </tr>
                                                        @endforeach
                                                        
                                                        <tr>
                                                            <td class="borders">Total</td>
                                                            <td class="borders"></td>
                                                            <td class="borders"></td>
                                                            <td class="borders"></td>
                                                            <td class="borders"></td>
                                                            <td class="borders">{{$jobcard->total_tones}}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <h4>Creasing Pattern </h4>
                                                <table class="table table-striped table-bordered zero-configuration" cellpadding="2">
                                                    
                                                    <thead>
                                                        <tr>
                                                            <td class="borders">{{ NumberFormat($jobcard->crease_part1) }}</td>
                                                            <td class="borders" colspan="8"></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="borders">{{ NumberFormat($jobcard->crease_part2) }}</td>
                                                            <td class="borders">{{ $jobcard->cp2_1 }}</td>
                                                            <td class="borders">{{ $jobcard->cp2_2 }}</td>
                                                            <td class="borders">{{ $jobcard->cp2_3 }}</td>
                                                            <td class="borders">{{ $jobcard->cp2_4 }}</td>
                                                            <td class="borders">{{ $jobcard->cp2_5 }}</td>
                                                            <td class="borders">{{ $jobcard->cp2_6 }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="borders">{{ NumberFormat($jobcard->crease_part3 )}}</td>
                                                            <td class="borders" colspan="2">{{ $jobcard->cp3_1 }}</td>
                                                            <td class="borders" colspan="2">{{ $jobcard->cp3_2 }}</td>
                                                            <td class="borders" colspan="2">{{ $jobcard->cp3_3 }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td class="borders">{{ NumberFormat($jobcard->crease_part4) }}</td>
                                                            <td class="borders" colspan="8"></td>
                                                        </tr>
                                                    </thead>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                
                                    <h5>Comment:</h5>
                                    <table class="table table-striped table-bordered zero-configuration" cellpadding="5">
                                        <tr>
                                            <td width="50%">
                                                <h4><b><u>BOX Details</u></b></h4>
                                                <table class="item-comment">
                                                    <thead>
                                                        <tr>
                                                            <td class="borders"><b>Carton/Bundle</b></td>
                                                            <td class="borders">
                                                                {{$jobcard->cortons_bundle}}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="borders"><b>Mfg Joint</b></td>
                                                            <td class="borders">
                                                                {{$jobcard->mfg_joint}}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="borders"><b>Die No.</b></td>
                                                            <td class="borders">
                                                                {{ NumberFormat($jobcard->die_no) }}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="borders"><b>Diecut Outs:</b></td>
                                                            <td class="borders">
                                                                {{ NumberFormat($jobcard->die_cut_outs) }}
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="borders"><b>SHEET WEIGHT (g)</b></td>
                                                            <td class="borders">
                                                                {{ NumberFormat($jobcard->sheet_weight) }}
                                                            </td>
                                                        </tr>
                                                    </thead>
                                                </table>
                                            </td>
                                            <td width="50%">
                                                {{-- {{dd(asset('storage/img/jobcard/'.$jobcard->design))}} --}}
                                                <img src="{{ Storage::disk('public')->url('app/public/img/company/Board_box.png') }}" style="object-fit:contain" width="100%"/>
                                                {{-- <img src="{{ asset('storage/img/company/Board_box.png') }}" style="object-fit:contain" width="100%"/> --}}
                                            </td>
                                        </tr>
                                    </table>
                                <table class="table table-striped table-bordered zero-configuration">
                                        <tr>
                                            <td>
                                                <table class="tray" cellpadding="2">
                                                    
                                                    <thead class="no">
                                                        <tr>
                                                            <td class="borders align-l" width="45%">Tray Creasing</td>
                                                            <td class="borders">x</td>
                                                        </tr>
                                                        
                                                    </thead>
                                                </table>
                                            </td>
                                            <td>
                                                <h3 class="float-right mt-1">Brown</h3>
                                            </td>
                                        </tr>
                                </table>
                                <h4>Printing Comment:</h4>
                                <table class="table table-striped table-bordered zero-configuration" cellpadding="4">
                                    <thead>
                                        <tr>
                                            <th>Process</th>
                                            <th>Date</th>
                                            <th>Operator Name</th>
                                            <th>Start Time</th>
                                            <th>End Time</th>
                                            <th>Recd. Qty</th>
                                            <th>B.Rej</th>
                                            <th>Qty. Prod</th>
                                            <th>Print Rej.</th>
                                            <th>Net Qty</th>
                                            <th>Opt Sign</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($jobcard->processes as $process)
                                        <tr>
                                            <td class="borders">{{$process->process_item->process_name}}</td>
                                            <td class="borders">{{$process->date}}</td>
                                            <td class="borders">{{$process->hrm ? $process->hrm->first_name.' '.$process->hrm->last_name : ''}}</td>
                                            <td class="borders">{{$process->start_time}}</td>
                                            <td class="borders">{{$process->end_time}}</td>
                                            <td class="borders">{{$process->record_qty}}</td>
                                            <td class="borders">{{$process->board_rej}}</td>
                                            <td class="borders">{{$process->qty_produced}}</td>
                                            <td class="borders">{{$process->print_rej}}</td>
                                            <td class="borders">{{$process->net_qty}}</td>
                                            <td class="borders">{{$process->operator_sign}}</td>
                                            
                                        </tr>
                                        @endforeach
                                                <tr>
                                            <td class="align-c" colspan="12">Total Rejection</td>
                                        </tr>
                                    </tbody>
                                </table>
                                <br>
                                <table class="table table-striped table-bordered zero-configuration" cellpadding="4">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            @foreach ($jobcard->dispatch as $dispatch)
                                                <th>
                                                    {{$dispatch->dispatch_name}}
                                                </th>
                                            @endforeach
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($dispatch_category as $category)
                                            <tr>
                                                <td>{{$category->name}}</td>
                                                
                                                    {{-- @foreach ($category->dispatch_category_items as $item)
                                                        <td>{{$item->dispatch_value}}</td>
                                                    @endforeach --}}
                                                
                                                    @foreach ($jobcard->dispatch as $item)
                                                        <td>
                                                            @foreach ($item->dispatch_items as $dis_item)
                                                            {{-- {{dd($dis_item->dispatch_value)}} --}}
                                                                @if ($dis_item->dispatch_category_id === $category->id)
                                                                    {{$dis_item->dispatch_value}}
                                                                    <br>
                                                                @endif
                                                            @endforeach
                                                        </td>
                                                    
                                                    @endforeach
                                            </tr>
                                        
                                        @endforeach
                                                
                                    </tbody>
                                </table>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('focus.jobcards.modal.attach-bom')
        @include('focus.jobcards.partials.approval')
        @include('focus.jobcards.partials.job-status')
    </div>
@endsection
@section('extra-scripts')
    @include('focus.jobcards.form-js')
@endsection