@extends ('core.layouts.app')

@section ('title', 'Paper Management')

@section('page-header')
    <h1>Paper Management</h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h4 class="content-header-title mb-0">Paper Management</h4>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        <div class="media-body media-right text-right">
                            @include('focus.papers.partials.papers-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <div class="form-group row">
                                    <div class="col-2">
                                        <form action="{{route('biller.products.print_paper_inventory')}}" method="post">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-success"><i class="fa fa-print" aria-hidden="true"></i> Print</button>
                                        </form>
                                        {{-- <a href="{{route('biller.products.print_paper_inventory')}}" type="submit" class="btn btn-lg btn-success">Paper Inventory</a> --}}
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-4">
                                        <label for="supplier">Search Supplier</label>
                                        <select name="supplier" id="supplier" class="form-control" data-placeholder="Search Supplier">
                                            @foreach ($suppliers as $supplier)
                                                <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-4">
                                        <label for="gsm">Search GSM</label>
                                        <select name="gsm_id" id="gsm" class="form-control" data-placeholder="Search GSM">
                                            @foreach ($gsms as $gsm)
                                                <option value="{{ $gsm->id }}">{{ $gsm->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-4">
                                        <label for="paper_width">Search Paper Width</label>
                                        <select name="paper_width_id" id="paper_width" class="form-control" data-placeholder="Search Paper Width">
                                            @foreach ($paper_widths as $paper_width)
                                                <option value="{{ $paper_width->id }}">{{ $paper_width->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    
                                </div>
                                
                            </div>

                            <div class="card-content">

                                <div class="card-body">
                                    <table id="papers-table"
                                           class="table table-striped table-bordered zero-configuration" cellspacing="0"
                                           width="100%">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Paper Width</th>
                                            <th>GSM</th>
                                            <th>Supplier</th>
                                            <th>Price</th>
                                            <th>{{ trans('labels.general.actions') }}</th>
                                        </tr>
                                        </thead>


                                        <tbody>
                                        <tr>
                                            <td colspan="100%" class="text-center text-success font-large-1"><i
                                                        class="fa fa-spinner spinner"></i></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    {{-- For DataTables --}}
    {{ Html::script(mix('js/dataTable.js')) }}
    {{ Html::script('focus/js/select2.min.js') }}
    {{-- <script>
        $(function () {
            setTimeout(function () {
                draw_data()
            }, {{config('master.delay')}});
        });

        function draw_data() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            var dataTable = $('#papers-table').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                language: {
                    @lang('datatable.strings')
                },
                ajax: {
                    url: '{{ route("biller.papers.get") }}',
                    type: 'post'
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    {data: 'paper_width', name: 'paper_width'},
                    {data: 'gsm', name: 'gsm'},
                    {data: 'supplier', name: 'supplier'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print'],
            });
            $('#papers-table_wrapper').removeClass('form-inline');

        }
    </script> --}}
    <script>
        const config = {
            ajax: {headers: {'X-CSRF-TOKEN':"{{ csrf_token() }}"}},
        };
        const Index = {
            init(){
                $.ajaxSetup(config.ajax);
                $('#supplier').select2({allowClear: true}).val('').trigger('change').change(this.supplierChange);
                $('#gsm').select2({allowClear: true}).val('').trigger('change').change(this.gsmChange);
                $('#paper_width').select2({allowClear: true}).val('').trigger('change').change(this.paperWidthChange);
                this.drawDataTable();
            },
            supplierChange(){
                $('#papers-table').DataTable().destroy();
                return Index.drawDataTable();
            },
            gsmChange(){
                $('#papers-table').DataTable().destroy();
                return Index.drawDataTable();
            },
            paperWidthChange(){
                $('#papers-table').DataTable().destroy();
                return Index.drawDataTable();
            },
            drawDataTable() {
                $('#papers-table').dataTable({
                    processing: true,
                    serverSide: true,
                    responsive: true,
                    language: {
                        @lang('datatable.strings')
                    },
                    ajax: {
                        url: '{{ route("biller.papers.get") }}',
                        type: 'post',
                        data: {
                            supplier_id: $('#supplier').val(),
                             gsm_id: $('#gsm').val(),
                             paper_width_id: $('#paper_width').val()
                            }
                    },
                    columns: [
                        {data: 'DT_Row_Index', name: 'id'},
                        {data: 'paper_width', name: 'paper_width'},
                        {data: 'gsm', name: 'gsm'},
                        {data: 'supplier', name: 'supplier'},
                        {data: 'price', name: 'price'},
                        {data: 'actions', name: 'actions', searchable: false, sortable: false}
                    ],
                    order: [[0, "asc"]],
                    searchDelay: 500,
                    dom: 'Blfrtip',
                    buttons: ['csv', 'excel', 'print'],
                });
            },
        };
        $(() => Index.init());
    </script>
@endsection
