<div class='form-group row'>
    <div class='col-3'>
        {{ Form::label( 'name', 'Customer Name',['class' => 'control-label']) }}
        {{-- {{ Form::text('name', null, ['class' => 'form-control round', 'placeholder' => 'Customer Name']) }} --}}
        <select name="customer_id" id="customer" class="form-control" data-placeholder="Search Customer">
            <option value="">Search Customer</option>
            @foreach ($customers as $customer)
                <option value="{{ $customer->id }}" {{$customer->id == @$print_designs->customer_id ? 'selected' : ''}}>{{ $customer->company }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-4">
        {{ Form::label( 'design', 'Print & Design',['class' => 'control-label']) }}
        {!! Form::file('design', array('class'=>'input form-control' )) !!}  @if(@$print_designs->id)
        <small>{{trans('hrms.blank_field')}}</small>
        @endif
    </div>
    <div class="col-3">
        {{ Form::label( 'status', 'Status',['class' => 'control-label']) }}
        <select name="status" id="status" class="form-control">
            <option value="">----Select Status----</option>
            @foreach (['active','inactive'] as $item)
                <option value="{{$item}}" {{$item == @$print_designs->status ? 'selected' : ''}}>{{ucfirst($item)}}</option>
            @endforeach
        </select>
    </div>
</div>
<div class='form-group row'>
    <div class='col-lg-10'>
        {{ Form::label( 'description', 'Description',['class' => 'control-label']) }}
        {{ Form::text('description', null, ['class' => 'form-control round', 'placeholder' => 'Description']) }}
    </div>
</div>
@section("after-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
        const config = {
            select2: {allowClear: true},
            ajaxSetup: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
            date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
        };
        const Form = {
            init(){
                $.ajaxSetup(config.ajaxSetup);
                $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
                $('#customer').select2(config.select2);
            },
        };
        $(()=>Form.init());
    </script>
@endsection
