@extends ('core.layouts.app')

@section ('title', 'Print & Design Management')

@section('page-header')
    <h1>{{ 'Print & Design Management' }}</h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h4 class="content-header-title mb-0">{{ 'Print & Design Management' }}</h4>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        <div class="media-body media-right text-right">
                            @include('focus.print_designs.partials.print_designs-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body" id="filters">
                <div class="row form-group">
                    {{-- <div class="col-md-12">
                        <div class="card">
                            <div class="mb-3">
                                <label for="category">Filter by Category:</label>
                                <select id="category" class="form-select">
                                    <option value="">All</option>
                                    <!-- Populate options with categories from your database -->
                                </select>
                            </div>
                        </div>
                    </div> --}}
                    <div class='col-3 justify-content-center'>
                        {{ Form::label( 'name', 'Customer Name',['class' => 'control-label']) }}
                        {{-- {{ Form::text('name', null, ['class' => 'form-control round', 'placeholder' => 'Customer Name']) }} --}}
                        <select name="customer_id" id="customer" class="form-control" data-placeholder="Search Customer">
                            <option value="">Search Customer</option>
                            @foreach ($customers as $customer)
                                <option value="{{ $customer->id }}" {{$customer->id == @$print_design->customer_id ? 'selected' : ''}}>{{ $customer->company }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="row" id="card-container">
                    @include('focus.print_designs.partials.card')
                    
                </div>
                <div class="row">
                    <div class="col-md-12">
                        {{-- {{ $cards->links() }} --}}
                    </div>
                </div>
            
                    {{-- <div class="col-12">
                        <div class="card">

                            <div class="card-content">

                                <div class="card-body">
                                    <table id="print_designs-table"
                                           class="table table-striped table-bordered zero-configuration" cellspacing="0"
                                           width="100%">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Customer Name</th>
                                            <th>Description</th>
                                            <th>Design</th>
                                            <th>Status</th>
                                            <th>{{ trans('labels.general.actions') }}</th>
                                        </tr>
                                        </thead>


                                        <tbody>
                                        <tr>
                                            <td colspan="100%" class="text-center text-success font-large-1"><i
                                                        class="fa fa-spinner spinner"></i></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div> --}}
                </div>
            </div>
        </div>
    </div>
@endsection

{{-- @section('after-scripts')

    {{ Html::script(mix('js/dataTable.js')) }}
    <script>
        $(function () {
            setTimeout(function () {
                draw_data()
            }, {{config('master.delay')}});
        });

        function draw_data() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            var dataTable = $('#print_designs-table').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                language: {
                    @lang('datatable.strings')
                },
                ajax: {
                    url: '{{ route("biller.print_designs.get") }}',
                    type: 'post'
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    {data: 'customer', name: 'customer'},
                    {data: 'description', name: 'description'},
                    {data: 'design', name: 'design'},
                    {data: 'status', name: 'status'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "asc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: {
                    buttons: [

                        {extend: 'csv', footer: true, exportOptions: {columns: [0, 1]}},
                        {extend: 'excel', footer: true, exportOptions: {columns: [0, 1]}},
                        {extend: 'print', footer: true, exportOptions: {columns: [0, 1]}}
                    ]
                }
            });
            $('#print_designs-table_wrapper').removeClass('form-inline');

        }
    </script>
@endsection --}}
@section("after-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
        const config = {
            select2: {allowClear: true},
            ajaxSetup: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
            date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
        };
        const Form = {
            init(){
                $.ajaxSetup(config.ajaxSetup);
                $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
                $('#customer').select2(config.select2);
                $('#filters').on('change', '#customer, #status', this.customerChange);
            },
            customerChange(){
                var customer = $('#customer').val();
                    $.ajax({
                        url: '{{ route("biller.print_designs.get") }}',
                        type: 'post',
                        data: { customer: customer },
                        success: function (data) {
                            if (data && data.length) {
                                $('#card-container').html('');
                                $('#card-container').append(data);
                            }else{
                                $('#card-container').html('');
                                $('#card-container').append('<p>No Data Found</p>');
                            }
                        }
                 });
            },
        };
        $(()=>Form.init());
    </script>
@endsection
