@extends ('core.layouts.app')
@section('title', trans('labels.backend.products.management'))

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            {{-- <h4 class="content-header-title">{{ trans('labels.backend.products.management') }}</h4> --}}
            <h4 class="content-header-title">Product Conversion</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    {{-- @include('focus.products.partials.products-header-buttons') --}}
                </div>
            </div>
        </div>
    </div>


    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-header">
                            <h4 class="card-title">
                                <div class="container">
                                    {{ trans('products.general_product_details') }}
                                    <a href="{{ route('biller.products.edit', [$product_conversion['id']]) }}" class="btn btn-blue btn-outline-accent-5 btn-sm float-right">
                                        <i class="fa fa-pencil"></i> {{ trans('buttons.general.crud.edit') }}
                                    </a>
                                </div>

                            </h4>
                        </div>

                        <div class="card-body">
                            <div class="container">
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        {{-- {{ trans('products.name') }} --}}
                                        Product
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product_conversion['in_house_product'] }}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        {{-- {{ trans('products.taxrate') }} --}}
                                        Unit Quantity
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product_conversion['in_house_product_quantity'] }}
                                    </div>
                                </div>
                                <br>

                                <h4>Raw material products</h4>

                                @if (isset($product_conversion->product_conversion_raw_materials))
                                <table class="table table-bordered">
                                    <thead>
                                        <th>Product</th>
                                        <th>Unit Quantity</th>
                                    </thead>
                                    <tbody>
                                        @foreach ($product_conversion->product_conversion_raw_materials as $row)
                                        <tr>
                                            <td>
                                                {{$row->raw_material}}
                                            </td>
                                            <td>
                                                {{$row->raw_material_quantity}}
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
