@extends ('core.layouts.app')

@section ('title', 'Product Barcodes')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Product Barcodes</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-3">
                                <label for="warehouse" class="h4">Product Location</label>
                                <select name="warehouse_id" id="warehouse" class="custom-select">
                                    <option value="">-- select location --</option>
                                    @foreach ($warehouses as $warehouse)
                                        <option value="{{ $warehouse->id }}">{{ $warehouse->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-3">
                                <label for="category" class="h4">Product Category</label>
                                <select name="category_id" id="category" class="custom-select">
                                    <option value="">-- select category --</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}">
                                            {{ $category->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-3">
                                <label for="status" class="h4">Product Status</label>
                                <select name="status" id="status" class="custom-select">
                                    <option value="">-- select status --</option>
                                    @foreach (['in_stock', 'out_of_stock'] as $status)
                                        <option value="{{ $status }}">{{ ucfirst(str_replace('_', ' ', $status)) }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-3">
                                <label for="status" class="h4">Stock Type</label>
                                <select name="stock_type" id="stock_type" class="custom-select">
                                    <option value="">-- select stock type --</option>
                                    @foreach (['raw-material','consumable','service' ] as $stock_type)
                                        <option value="{{ $stock_type }}">{{ ucfirst(str_replace('_', ' ', $stock_type)) }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">

                            <form action="{{ route('biller.pb.print') }}" method="post">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="row">
                                                    <button class="btn btn-primary" type="submit">Print
                                                        Barcode</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @csrf
                                <table id="productsTbl" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Select Products</th>
                                            <th>Description</th>
                                            <th>SKU</th>
                                            <th>Location</th>
                                            <th>Qty</th>
                                            <th>UoM</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="100%" class="text-center text-success font-large-1">
                                                <i class="fa fa-spinner spinner"></i>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}" }}
    };

    const Index = {
        status: '',
        stock_type: '',
        warehouseId: @json(request('warehouse_id')),
        categoryId: @json(request('productcategory_id')),

        init() {
            this.drawDataTable();
            $('#status').change(this.statusChange);
            $('#stock_type').change(this.stockTypeChange);
            $('#warehouse').val(this.warehouseId).change(this.warehouseChange);
            $('#category').val(this.categoryId).change(this.categoryChange);
        },

        categoryChange() {
            Index.categoryId = $(this).val();
            $('#productsTbl').DataTable().destroy();
            return Index.drawDataTable();
        },

        warehouseChange() {
            Index.warehouseId = $(this).val();
            $('#productsTbl').DataTable().destroy();
            return Index.drawDataTable();
        },

        statusChange() {
            Index.status = $(this).val();
            $('#productsTbl').DataTable().destroy();
            return Index.drawDataTable();
        },
        stockTypeChange() {
            Index.stock_type = $(this).val();
            $('#productsTbl').DataTable().destroy();
            return Index.drawDataTable();
        },

        drawDataTable() {
            $('#productsTbl').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                stateSave: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: '{{ route("biller.products.get-for-barcodes") }}',
                    type: 'post',
                    data: {
                        warehouse_id: this.warehouseId,
                        category_id: this.categoryId,
                        status: this.status,
                        stock_type: this.stock_type
                    },
                    dataSrc: ({data}) => {
                        $('.stock-count').text('0');
                        $('.stock-worth').text('0.00');
                        if (data.length && data[0].aggregate) {
                            const aggr = data[0].aggregate;
                            $('.stock-count').text(aggr.product_count);
                            $('.stock-worth').text(aggr.product_worth);
                        }
                        return data;
                    },
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    {data: 'mass_select',name: 'mass_select'},
                    {data: 'name', name: 'name'},
                    {data: 'sku', name: 'sku'},
                    {data: 'location', name: 'location'},
                    {data: 'qty', name: 'qty'},
                    {data: 'unit', name: 'unit'},
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print']
            });
        },
    };

    $(() => Index.init());
</script>
@endsection
