{{-- Product --}}
<h4>{{trans('products.general_product_details')}}</h4>
<div class="row form-group">
    <div class="col-6">
        {{-- {{ Form::label( 'name', trans('products.name'),['class' => 'control-label']) }} --}}
        <label for="name" class="control-label">{{trans('products.name')}}<span class="text-danger">*</span></label>
        {{ Form::text('name', null, ['class' => 'form-control box-size', 'placeholder' => trans('products.name').'*','required'=>'required']) }}
    </div>
    <div class="col-2">
        {{ Form::label('taxrate', 'Tax %', ['class' => 'control-label']) }}
        {{ Form::text('taxrate', numberFormat(@$produc->taxrate), ['class' => 'form-control box-size', 'placeholder' => trans('products.taxrate'),'onkeypress'=>"return isNumber(event)"]) }}
    </div>
    <div class="col-2">
        {{ Form::label('unit', trans('products.stock_type'),['class' => 'control-label']) }}
        <select class="custom-select" name="stock_type">
            @foreach (['stock', 'consumable', 'service', 'waste','finished_goods'] as $i => $val)
                <option value="{{ $val }}" {{ @$product->stock_type == $val? 'selected' : '' }}>
                    {{ ucfirst($val) }}
                </option>
            @endforeach
        </select>
    </div>
    <div class="col-2">
        <label for="sku">Stock Keeping Unit (SKU)</label>
        {{ Form::text('sku', null, ['class' => 'form-control']) }}
    </div>
    
</div>
<div class="row form-group">
    <div class="col-4">
        {{ Form::label('product_des', trans('products.product_des'),['class' => 'control-label']) }}
        {{ Form::textarea('product_des', null, ['class' => 'form-control col', 'rows'=>2, 'placeholder' => trans('products.product_des')]) }}
    </div>
    
    {{-- <div class="col-2">
        <div class='form-group'>
            {{ Form::label('code', trans('products.code'),['class' => 'col control-label']) }}
            <div class='col'>
                {{ Form::text('code', @$product->standard['code'], ['class' => 'form-control box-size', 'placeholder' => trans('products.code')]) }}
            </div>
        </div>
    </div> --}}

    

    <div class="col-2">
        {{ Form::label('unit', 'Base Unit', ['class' => 'control-label']) }}
        <select class="custom-select" name="unit_id" id="unit" required>
            <option value="">-- Choose Base Unit --</option>
            @foreach($productvariables as $item)
                @if ($item->unit_type == 'base')
                    <option value="{{ $item->id }}" {{ $item->id == @$product->unit_id ? 'selected' : '' }} >
                        {{ $item->code }} ({{ $item->title }})
                    </option>    
                @endif
            @endforeach
        </select>
    </div>
    <div class="col-3">
        {{ Form::label('unit', 'Compound Unit', ['class' => 'control-label']) }}
        <select class="custom-select" name="compound_unit_id[]" id="compound_unit" data-placeholder="Choose Compound Units" multiple>
            @isset($compound_unit_ids)
                @foreach($productvariables as $item)
                    @if (in_array($item->id, $compound_unit_ids))
                        <option  value="{{ $item->id }}"  selected>
                            {{ $item->code }} ({{ +$item->base_ratio }} units)
                        </option> 
                    @endif
                @endforeach
            @endisset
        </select>
    </div>
    <div class="col-3">
        <label for="category" class="h4">Product Category</label>
        <select name="productcategory_id" class="custom-select">
            <option value="">-- select category --</option>
            @foreach ($product_categories as $category)
                <option value="{{ $category->id }}" {{$category->id == @$product->productcategory_id ? 'selected' : ''}}>
                    {{ $category->title }}
                </option>
            @endforeach
        </select>
    </div>  
</div>
<div class="form-group row">
   <div class="col-4">
    <label for="supplier">Select Prefered Supplier</label>
    <select name="supplier_id" id="supplier" class="form-control" data-placeholder="Search Supplier">
        <option value="">Search Supplier</option>
        @foreach ($suppliers as $supplier)
            <option value="{{$supplier->id}}" {{$supplier->id == @$product->supplier_id ? 'selected' : ''}}>{{$supplier->name}}</option>
        @endforeach
    </select>
   </div>
   <div class='col-4'>
    <label for="receivable_account">Ledger Accounts</label>
    <select name="ledger_id" id="ledger_id" class="custom-select">
        <option value="">-- Select Subcategory Account --</option>
        @foreach ($account->subledgers as $row)
            <option value="{{ $row->id }}" {{ $row->id == @$product->ledger_id? 'selected' : '' }}>
                {{ $row->name }}
            </option>
        @endforeach
    </select>
</div>
    
</div>
<hr class="mb-3">

{{-- Standard Product Variation --}}
<h4>Extra Products Details</h4>
<div id="main_product">
    <div class="product round">
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    {{-- {{ Form::label( 'warehouse_id', trans('products.warehouse_id'),['class' => 'col control-label']) }} --}}
                    <label for="warehouse_id">WareHouse<span class="text-danger">*</span></label>
                    
                    <div class='col'>
                        <select class="custom-select" name="warehouse_id" required>
                            <option value="">Select WareHouse</option>
                            @foreach($warehouses as $item)
                                <option value="{{$item->id}}" {{ $item->id == @$product->warehouse_id ? "selected" : "" }}>
                                    {{$item->title}}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class='form-group'>
                    {{ Form::label( 'purchase_price', trans('products.purchase_price'),['class' => 'col control-label']) }}
                    <div class='col'>
                        {{ Form::text('purchase_price', numberFormat(@$product->purchase_price), ['class' => 'form-control box-size', 'placeholder' => trans('products.purchase_price'),'onkeypress'=>"return isNumber(event)"]) }}
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class='form-group'>
                    {{ Form::label( 'qty', trans('products.qty'),['class' => 'col control-label']) }}
                    <div class='col'>
                        {{ Form::text('qty', numberFormat(@$product->qty), ['class' => 'form-control box-size', 'placeholder' => trans('products.qty'),'onkeypress'=>"return isNumber(event)"]) }}
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class='form-group'>
                    {{ Form::label( 'weight', 'Weight',['class' => 'col control-label']) }}
                    <div class='col'>
                        {{ Form::text('weight', numberFormat(@$product['weight']), ['class' => 'form-control box-size', 'placeholder' => 'Weight','onkeypress'=>"return isNumber(event)"]) }}
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            
            {{-- <div class="col-md-3">
                <div class='form-group'>
                    {{ Form::label('serial', 'Serial Number',['class' => 'col control-label']) }}
                    <div class='col'>
                        {{ Form::text('serial', @$product->standard['serial'], ['class' => 'form-control box-size', 'placeholder' => 'Serial Number']) }}
                    </div>
                </div>
            </div> --}}
            <div class="col-md-3">
                <div class='form-group'>
                    {{ Form::label( 'date', 'As at Date',['class' => 'col control-label']) }}
                    <div class='col'>
                        {{ Form::text('date', dateFormat(@$product->standard['date']), ['class' => 'form-control datepicker']) }}
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class='form-group'>
                    {{-- {{ Form::label('alert', 'Qty Alert Limit',['class' => 'col control-label']) }} --}}
                    <label for="alert" class="control-label col">Qty Alert Limit<span class="text-danger">*</span></label>
                    
                    <div class='col'>
                        {{ Form::text('alert', numberFormat(@$product['alert']), ['class' => 'form-control box-size', 'placeholder' => trans('products.alert'),'onkeypress'=>"return isNumber(event)",'required'=>'required']) }}
                    </div>
                </div>
            </div>
            
        </div>
        <hr>
        <h4>Dimensions Details</h4>
        <div class="form-group row">
            <div class="col-md-3">
                <div class='form-group'>
                    {{ Form::label( 'lenght', 'Lenght',['class' => 'col control-label']) }}
                    <div class='col'>
                        {{ Form::text('lenght', numberFormat(@$product['lenght']), ['class' => 'form-control box-size', 'placeholder' => 'Lenght','onkeypress'=>"return isNumber(event)"]) }}
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class='form-group'>
                    {{ Form::label( 'width', 'Width',['class' => 'col control-label']) }}
                    <div class='col'>
                        {{ Form::text('width', numberFormat(@$product['width']), ['class' => 'form-control box-size', 'placeholder' => 'Width','onkeypress'=>"return isNumber(event)"]) }}
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class='form-group'>
                    {{ Form::label( 'height', 'Height',['class' => 'col control-label']) }}
                    <div class='col'>
                        {{ Form::text('height', numberFormat(@$product['height']), ['class' => 'form-control box-size', 'placeholder' => 'Height','onkeypress'=>"return isNumber(event)"]) }}
                    </div>
                </div>
            </div>
        </div>
        <span class="col-6 del_b"></span>
        <hr>
    </div>
</div>




@section("after-styles")
<style>
    #added_product div:nth-child(even) .product {
        background: #FFF
    }

    #added_product div:nth-child(odd) .product {
        background: #eeeeee
    }

    #product_sub div:nth-child(odd) .v_product_t {
        background: #FFF
    }

    #product_sub div:nth-child(even) .v_product_t {
        background: #eeeeee
    }
</style>
{!! Html::style('focus/css/select2.min.css') !!}
@endsection

@section("after-scripts")
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    const config = {
        datepicker: {
            autoHide: true,
            format: "{{config('core.user_date_format')}}"
        },
    };
   
    const Form = {
        units: @json($productvariables),

        init() {
            $('.datepicker').datepicker(config.datepicker);
            $('#compound_unit').select2();
            $('#supplier').select2();

            $('#unit').change(this.unitChange);

            const events = [".add_more", ".add_serial", ".v_delete", ".v_delete_temp", ".v_delete_serial"];
            const handlers = [this.addMore, this.addSerial, this.delVariableProduct, this.delProduct, this.delSerial];
            events.forEach((v,i) => $(document).on('click', v, handlers[i]));
        },

        unitChange() {
            const el = $(this);
            const compoundUnits = Form.units.filter(v => v.base_unit_id == el.val())
            .map(v => ({id: v.id, text: `${v.code} (${parseFloat(v.base_ratio)} units)`}));

            $('#compound_unit option').remove();
            $('#compound_unit').select2({data: compoundUnits});
        },

        addMore(e) {
            e.preventDefault();
            var product_details = $('#main_product').clone().find(".old_id input:hidden").val(0).end();
            product_details.find(".del_b").append('<button class="btn btn-danger v_delete_temp m-1 align-content-end"><i class="fa fa-trash"></i> </button>').end();
            $('#added_product').append(product_details);
            $('.datepicker').datepicker(config.datepicker);
        },

        delVariableProduct(e) {
            e.preventDefault();
            var p_v = $(this).closest('div').attr('data-vid');
            $('#remove_variation').append("<input type='hidden' name='remove_v[]' value='" + p_v + "'>");
            alert("{{trans('products.alert_removed')}}");
            $('#pv_' + p_v).remove();        
        },

        delProduct(e) {
            e.preventDefault();
            $(this).closest('div .product').remove();
        },

        addSerial(e) {
            e.preventDefault();
            $('#added_product').append(
                `<div class="form-group serial"><label for="field_s" class="col-lg-2 control-label">{{trans('products.product_serial')}}</label><div class="col-lg-10">
                <input class="form-control box-size" placeholder="{{trans('products.product_serial')}}" name="product_serial[]" type="text"  value=""></div>
                <button class="btn-sm btn-purple v_delete_serial m-1 align-content-end"><i class="fa fa-trash"></i> </button></div>`
            );
        },

        delSerial(e) {
            e.preventDefault();
            $(this).closest('div .serial').remove();
        },
    };

    $(() => Form.init());
</script>
@endsection