<div class="form-group row">
    <div class="col-4">
        <label for="customer">Search Customer</label>
        <select id="customer" name="customer_id" class="form-control select-box" data-placeholder="{{ trans('customers.customer') }}" required>
            <option value="">--Select Customer--</option>
            @foreach ($customers as $customer)
                <option value="{{$customer->id}}" {{@$project->customer_id == $customer->id ? 'selected':'' }}>{{$customer->company}}</option>
            @endforeach
        </select>
    </div>
   
    <div class="col-4">
        <label for="projectTitle">Project Title</label>
        {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => trans('projects.name')]) }}
    </div>
    <div class="col-4">
        <label for="needed_qty">Total Qty Ordered</label>
        {{ Form::text('qty_needed', @$project->qty_needed ?:0, ['class' => 'form-control', 'placeholder' => '0.00','readonly','id'=>'qty']) }}
    </div>
</div>
<div class="form-group row">
    <div class="col-4">
        <label for="description">Project Description</label>
        {{ Form::text('description', null, ['class' => 'form-control', 'row'=>'3', 'placeholder' => 'Project Description']) }}
    </div>
    <div class="col-2">
        <label for="priority">Search priority</label>
        <select id="priority" name="priority" class="form-control select-box" data-placeholder="Select Priority" required>
            @foreach (['low','medium','high','urgent'] as $priority)
                <option value="{{$priority}}">{{ucfirst($priority)}}</option>
            @endforeach
        </select>
    </div>
    <div class="col-2">
        <label for="start_date">Project Start Date</label>
        {{ Form::text('start_date', null, ['class' => 'form-control datepicker', 'placeholder' => '','id'=>'start_date']) }}
    </div>
    <div class="col-2">
        <label for="end_date">End Date</label>
        {{ Form::text('end_date', null, ['class' => 'form-control datepicker', 'placeholder' => '','id'=>'end_date']) }}
    </div>
    <div class="col-2">
        <label for="delivery_date">Delivery Date</label>
        {{ Form::text('delivery_date', null, ['class' => 'form-control datepicker', 'placeholder' => '','id'=>'delivery_date']) }}
    </div>
    
</div>