@extends ('core.layouts.app', ['page' => 'class="horizontal-layout horizontal-menu content-detached-right-sidebar"
data-open="click" data-menu="horizontal-menu" data-col="content-detached-right-sidebar"'])

@section('title', trans('labels.backend.projects.management'))

@section('content')
<div class="content-wrapper">
    <div class="content-header row">
        <div class="content-header-left col-md-6 col-12 mb-2">
            <h3 class="content-header-title mb-0">{{ trans('projects.project_summary') }}</h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('biller.dashboard') }}">{{ trans('core.home') }}</a> </li>
                        <li class="breadcrumb-item"><a href="{{ route('biller.projects.index') }}">{{ trans('projects.projects') }}</a> </li>
                        <li class="breadcrumb-item active">{{ trans('projects.project_summary') }} </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="media width-250 float-right">
                <div class="media-left media-middle">
                </div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">{{ $project->name }}</h4>
            <div class="btn-group mt-1">
                <a href="#" class="btn btn-warning btn-sm mr-1" data-toggle="modal" data-target="#statusModal">
                    <i class="fa fa-pencil" aria-hidden="true"></i> Status
                </a>
                
            </div>
        </div>
        <div class="card-content">
            <div class="card-body" id="pro_tabs">
                <ul class="nav nav-tabs nav-top-border no-hover-bg" role="tablist">
                    {{-- project summary --}}
                    <li class="nav-item">
                        <a class="nav-link active" id="tab1" data-toggle="tab" href="#tab_data1" aria-controls="tab_data1" role="tab" aria-selected="true">                                
                            <i class="fa fa-lightbulb-o"></i> {{ trans('projects.project_summary') }}
                        </a>
                    </li>
                    
                    {{-- project LPO --}}
                    <li class="nav-item">
                        <a class="nav-link" id="tab2" data-toggle="tab" href="#tab_data2" aria-controls="tab_data2" role="tab" aria-selected="true">
                            <i class="fa fa-money"></i>LPO
                        </a>                           
                    </li>
                    {{-- project milestone --}}
                    <li class="nav-item">
                        <a class="nav-link" id="tab3" data-toggle="tab" href="#tab_data3" aria-controls="tab_data3" role="tab" aria-selected="true">
                            <i class="fa fa-money"></i>Milestones & JobCard
                        </a>                           
                    </li>
                    {{-- project jobcard --}}
                    {{-- <li class="nav-item">
                        <a class="nav-link" id="tab4" data-toggle="tab" href="#tab_data4" aria-controls="tab_data4" role="tab" aria-selected="true">
                            <i class="fa fa-money"></i>JobCard
                        </a>                           
                    </li> --}}
                    {{-- project jobcard attachments --}}
                    <li class="nav-item">
                        <a class="nav-link" id="tab8" data-toggle="tab" href="#tab_data8" aria-controls="tab_data8" role="tab" aria-selected="true">
                            <i class="fa fa-money"></i>JobCard Attachments
                        </a>                           
                    </li>
                    {{-- project bom_items --}}
                    <li class="nav-item">
                        <a class="nav-link" id="tab5" data-toggle="tab" href="#tab_data5" aria-controls="tab_data5" role="tab" aria-selected="true">
                            <i class="font-weight-bold"></i>BOM Items
                        </a>                           
                    </li>
                    {{-- project Processes --}}
                    <li class="nav-item">
                        <a class="nav-link" id="tab6" data-toggle="tab" href="#tab_data6" aria-controls="tab_data6" role="tab" aria-selected="true">
                            <i class="font-weight-bold"></i>Processes(Tasks)
                        </a>                           
                    </li>
                    {{-- project Dispatch --}}
                    <li class="nav-item">
                        <a class="nav-link" id="tab7" data-toggle="tab" href="#tab_data7" aria-controls="tab_data7" role="tab" aria-selected="true">
                            <i class="font-weight-bold"></i>Dispatch
                        </a>                           
                    </li>
                    {{-- project Job Summary --}}
                    {{-- <li class="nav-item">
                        <a class="nav-link" id="tab10" data-toggle="tab" href="#tab_data10" aria-controls="tab_data10" role="tab" aria-selected="true">
                            <i class="font-weight-bold"></i>Jobs Summary
                        </a>                           
                    </li> --}}
                </ul>
                <div class="tab-content px-1 pt-1">
                    @include('focus.projects.tabs.summary')
                    @include('focus.projects.tabs.lpo')
                    @include('focus.projects.tabs.task_schedule')
                    @include('focus.projects.tabs.jobcard')
                    @include('focus.projects.tabs.attachments')
                    @include('focus.projects.tabs.bom_items')
                    @include('focus.projects.tabs.processes')
                    @include('focus.projects.tabs.dispatch')
                    @include('focus.projects.tabs.jobs_summary')
                </div>
            </div>
        </div>
    </div>
    @include('focus.projects.modal.quote_new')
    @include('focus.projects.modal.attach_image')
    @include('focus.projects.modal.task_new') 
    @include('focus.projects.modal.lpo_new') 
</div>
@endsection

@section('after-scripts')
{{ Html::script('focus/js/select2.min.js') }}
{{ Html::script(mix('js/dataTable.js')) }}
    @include('focus.projects.view-js')
@endsection
