<div class="form-group row">
    <div class="col-2">
        <label for="title">Requisition No.</label>
        {{ Form::text('tid', gen4tid('REQ-', @$purchase_request? $purchase_request->tid : @$tid+1), ['class' => 'form-control', 'disabled']) }}
        {{ Form::hidden('tid', @$purchase_request? $purchase_request->tid : @$tid+1) }}
    </div>

    <div class="col-4">
        <label for="employee">Requestor</label>
        <select name="employee_id" id="user" class="form-control" data-placeholder="Search Employee" required>
            @foreach ($users as $user)
                <option value="{{ $user->id }}" {{ @$purchase_request->employee_id == $user->id? 'selected' : '' }}>
                    {{ $user->full_name }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-2">
        <label for="date">Date</label>
        {{ Form::text('date', null, ['class' => 'form-control datepicker', 'id' => 'date']) }}
    </div>

    <div class="col-2">
        <label for="priority">Priority Level</label>
        <select name="priority" id="priority" class="custom-select">
            @foreach (['low', 'medium', 'high'] as $val)
                <option value="{{ $val }}" {{ @$purchase_request->priority == $val? 'selected' : '' }}>
                    {{ ucfirst($val) }}
                </option>
            @endforeach
        </select>
    </div>   

    <div class="col-2">
        <label for="expect_date">Expected Delivery Date</label>
        {{ Form::text('expect_date', null, ['class' => 'form-control datepicker', 'id' => 'expect_date']) }}
    </div>    
</div>

<div class="form-group row">
    <div class="col-6">
        <label for="title">Remark</label>
        {{ Form::text('note', null, ['class' => 'form-control', 'id' => 'note']) }}
    </div>
    <div class="col-2">
        <label for="select-type">Select Type</label>
        <select name="stock_job" class="form-control custom-select" id="stock-job">
            <option value="">----Select Type ------</option>
            <option value="0" {{ @$purchase_request->stock_job == '0' ? 'selected':'' }}>Stock</option>
            <option value="1" {{ @$purchase_request->stock_job == '1' ? 'selected':'' }}>Job Card</option>
        </select>
        
    </div>
    <div class="col-2 stock-div d-none">
        <label for="stock">Stock</label>
        {{ Form::text('stock', null, ['class' => 'form-control', 'id' => 'stock']) }}
    </div>
    <div class="col-2 job-div d-none">
        <label for="job-card">Job Card Number</label>
        {{ Form::text('job_card', null, ['class' => 'form-control', 'id' => 'job_card']) }}
    </div>
    <div class="col-2">
        <label for="select-item">Item Types</label>
        <select name="item_type" class="form-control custom-select" id="item_type">
            <option value="">----Select Type ------</option>
            <option value="other_items" {{ @$purchase_request->item_type == "other_items" ? 'selected':'' }}>Other Items</option>
            <option value="paper" {{ @$purchase_request->item_type == "paper" ? 'selected':'' }}>Paper</option>
        </select>
    </div>
</div>

@include('focus.purchase_requests.partials.add-items')
<div class="form-group row no-gutters">
    <div class="col-1 ml-auto">
        <a href="{{ route('biller.purchase_requests.index') }}" class="btn btn-danger block">Cancel</a>    
    </div>
    <div class="col-1 ml-1">
        @php
            $disabled = '';
            if (isset($purchase_request) && $purchase_request->status == 'approved')
                $disabled = 'disabled';
        @endphp
        {{ Form::submit(@$purchase_request? 'Update' : 'Create', ['class' => 'form-control btn btn-primary text-white', $disabled]) }}
    </div>
</div>

@section('extra-scripts')
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
        predict: (url, callback) => {
            return {
                source: function(request, response) {
                    $.ajax({
                        url,
                        dataType: "json",
                        method: "POST",
                        data: {keyword: request.term, projectstock: $('#projectstock').val()},
                        success: function(data) {
                            response(data.map(v => ({
                                label: v.name,
                                value: v.name,
                                data: v
                            })));
                        }
                    });
                },
                autoFocus: true,
                minLength: 0,
                select: callback
            };
        }
    };

    const Form = {
        purchaseRequest: @json(@$purchase_request),
        rowIds: 0,
        tableRow: $('#requisitionTbl tbody tr:first').html(),
        stockUrl: "{{ route('biller.products.purchase_search') }}",
        paperUrl: "{{ route('biller.products.paper_search') }}",

        init() {
            $.ajaxSetup(config.ajax);
            $('#user').select2({allowClear: true});
            $('.datepicker').datepicker(config.date)
            // initialize html editor
            editor();

            if (this.purchaseRequest) {
                const request = this.purchaseRequest;
                $('#date').datepicker('setDate', new Date(request.date));
                $('#expect_date').datepicker('setDate', new Date(request.expect_date));
                if(request.stock_job == '0'){
                    $('.stock-div').removeClass('d-none');
                    $('#stock').attr('disabled',false);
                    $('#stock').attr('readonly',true);
                    $('#stock').val('stock');
                    $('.job-div').addClass('d-none');
                    $('#job_card').attr('disabled',true);
                }
                else if(request.stock_job == '1'){
                    $('.stock-div').addClass('d-none');
                    $('.job-div').removeClass('d-none');
                    $('#job_card').attr('disabled',false);
                    $('#stock').attr('disabled',true);
                }
            } else {
                $('#user').val('').change();
                $('.datepicker').datepicker('setDate', new Date());
            }
            $('#user').change(this.employeeChange);
            $('#requisitionTbl tbody tr:first').remove();
            $('#item_type').change(function () { 
                if ($(this).val() == 'paper') {

                    $('.name').autocomplete(config.predict(this.paperUrl, Form.paperSelect));
                }
                else if ($(this).val() == 'other_items') {

                    $('.name').autocomplete(config.predict(this.stockUrl, Form.stockSelect));
                }
            });
            
            
            $('#addstock').click(this.addItem);
            $('#requisitionTbl').on('click', '.remove', this.removeRow);
            $('#stock-job').change(this.selectChange);
            
            
        },
        addItem() {
            Form.rowIds++;
            let i = Form.rowIds;
            const html = Form.tableRow.replace(/-0/g, '-'+i);
            $('#requisitionTbl tbody').append('<tr>' + html + '</tr>');
           // $('.name').autocomplete(config.predict(Form.stockUrl, Form.stockSelect));
            if ($('#item_type').val() == 'paper') {
                $('.name').autocomplete(config.predict(Form.paperUrl, Form.paperSelect));
            }
            else if ($('#item_type').val() == 'other_items') {
                $('.name').autocomplete(config.predict(Form.stockUrl, Form.stockSelect));
            }
           // $('#requisitionTbl').on('change','.deduct', deduct);
        },
        removeRow() {
            const $tr = $(this).parents('tr:first');
            $tr.remove();
        },
        stockSelect(event, ui) {
            const {data} = ui.item;
            // console.log(ui);
            const i =  Form.rowIds;
            $('#item-id-'+i).val(data.id);
            $('#name-'+i).val(data.name);
            $('#qty_stock-'+i).val(data.qty_stock);
            $('#supplier_id-'+i).val(data.supplier_id);
            $('#sku-'+i).val(data.sku);
            $('#type-'+i).val('other_items');

            if(data.uom){
                $('#uom-'+i).val(data.uom);
                $('#unit-'+i).val(data.unit);
            }
            
        },
        paperSelect(event, ui) {
            const {data} = ui.item;
            console.log(data);
            const i =  Form.rowIds;
            $('#item-id-'+i).val(data.id);
            $('#name-'+i).val(data.name);
            $('#qty_stock-'+i).val(data.qty_stock);
            $('#supplier_id-'+i).val(data.supplier_id);
            $('#sku-'+i).val(data.sku);
            $('#type-'+i).val('paper');


            if(data.uom){
                $('#uom-'+i).val(data.uom);
                $('#unit-'+i).val(data.unit);
            }
            
        },
        selectChange(){
            const el = $(this);
            if(el.val() == '0'){
                $('.stock-div').removeClass('d-none');
                $('#stock').attr('disabled',false);
                $('#stock').attr('readonly',true);
                $('#stock').val('stock');
                $('.job-div').addClass('d-none');
                $('#job_card').attr('disabled',true);
            }else if(el.val() == '1'){
                $('.stock-div').addClass('d-none');
                $('.job-div').removeClass('d-none');
                $('#job_card').attr('disabled',false);
                $('#stock').attr('disabled',true);
            }

        }
    };

    $(() => Form.init());
</script>
@endsection