@extends ('core.layouts.app')

@section('title', 'Purchase Requisition Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Purchase Requisition Management</h4>
        </div>
        <div class="col-6">
            <div class="btn-group float-right">
                @include('focus.purchase_requests.partials.purchase-request-header-buttons')
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <ul class="nav nav-tabs nav-top-border no-hover-bg" role="tablist">
                                {{-- project summary --}}
                                <li class="nav-item">
                                    <a class="nav-link active" id="tab1" data-toggle="tab" href="#tab_data1" aria-controls="tab_data1" role="tab" aria-selected="true">                                
                                        <i class="fa fa-lightbulb-o"></i> Rejected
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="tab1" data-toggle="tab" href="#tab_data2" aria-controls="tab_data2" role="tab" aria-selected="true">                                
                                        <i class="fa fa-lightbulb-o"></i> Requisition Pending Approval
                                    </a>
                                </li>
                                
                                {{-- project LPO --}}
                                <li class="nav-item">
                                    <a class="nav-link" id="tab3" data-toggle="tab" href="#tab_data3" aria-controls="tab_data3" role="tab" aria-selected="true">
                                        <i class="fa fa-money"></i>Pending Purchase
                                    </a>                           
                                </li>
                                {{-- project milestone --}}
                                <li class="nav-item">
                                    <a class="nav-link" id="tab4" data-toggle="tab" href="#tab_data4" aria-controls="tab_data4" role="tab" aria-selected="true">
                                        <i class="fa fa-money"></i> Complete Requisition
                                    </a>                           
                                </li>
                                
                            </ul>
                            <div class="tab-content px-1 pt-1">
                                @include('focus.purchase_requests.tabs.rejected')
                                @include('focus.purchase_requests.tabs.requisition_approved')
                                @include('focus.purchase_requests.tabs.purchase_pending')
                                @include('focus.purchase_requests.tabs.completed')
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>        
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script('focus/js/select2.min.js') }}
{{ Html::script(mix('js/dataTable.js')) }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
    };

    const Index = {
        init() {
        
            $.ajaxSetup(config.ajax);
            this.rejected();
            this.drawDataTable();
            this.requests();
            this.completed();
        },

        rejected() {
            $('#rejectedTbl').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: "{{ route('biller.purchase_requests.get') }}",
                    type: 'POST',
                    data: {requisition_rejected: "rejected"},
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    ...['tid', 'status', 'date', 'employee', 'priority', 'expect_date'].map(v => ({data: v, name: v})),
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print'],
            });
        },
        drawDataTable() {
            $('#requestsTbl').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: "{{ route('biller.purchase_requests.get') }}",
                    type: 'POST',
                    data: {requisition_approved: "approved",  requisition_pending: "pending"},
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    ...['tid', 'status', 'date', 'employee', 'priority', 'expect_date'].map(v => ({data: v, name: v})),
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print'],
            });
        },
        requests() {
                // if ($('#requestTbl tbody tr').length) return;        
                $('#requestTbl').dataTable({
                    processing: true,
                    responsive: true,
                    stateSave: true,
                    language: {@lang('datatable.strings')},
                    ajax: {
                        url: "{{ route('biller.purchase_requests.get') }}",
                        type: 'POST',
                        data: {purchase_status: "pending"},
                    },
                    columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    ...['tid','purchase_status', 'date', 'employee', 'priority', 'expect_date'].map(v => ({data: v, name: v})),
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                    order:[[0, 'desc']],
                    searchDelay: 500,
                    dom: 'Blfrtip',
                    buttons: ['csv', 'excel', 'print'],
                });
            },
        completed() {
                // if ($('#requestTbl tbody tr').length) return;        
                $('#completeTbl').dataTable({
                    processing: true,
                    responsive: true,
                    stateSave: true,
                    language: {@lang('datatable.strings')},
                    ajax: {
                        url: "{{ route('biller.purchase_requests.get') }}",
                        type: 'POST',
                        data: {purchase_status: "complete"},
                    },
                    columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    ...['tid', 'status','purchase_status', 'date', 'employee', 'priority', 'expect_date'].map(v => ({data: v, name: v})),
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                    order:[[0, 'desc']],
                    searchDelay: 500,
                    dom: 'Blfrtip',
                    buttons: ['csv', 'excel', 'print'],
                });
            } 
    };

    $(() => Index.init());
    // $(() =>{
    //             // on show tab load datatables
    //             $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    //                 localStorage.setItem('project_tab', $(e.target).attr('href'));
    //                 switch ($(e.target).attr('href')) {
    //                     case '#tab_data1': Index.drawDataTable(); break;
    //                     case '#tab_data2': Index.requests(); break;
    //                     // case '#tab_data3': Index.drawDataTable(); break; 
    //                 }
    //             });
    //             const projectTab = localStorage.project_tab;
    //             if (projectTab) $('a[href="' + projectTab + '"]').tab('show');
    //         });
</script>
@endsection
