<div class="row">
    <div class="col-sm-6 cmp-pnl">
        <div id="customerpanel" class="inner-cmp-pnl">
            <h3 class="title">Purchase </h3>                                                                
            <div class="form-group row" id="filters">
                <div class="col-4">
                    <div><label for="supplier-type">Select Supplier Type</label></div>
                    <div class="d-inline-block custom-control custom-checkbox mr-1">
                        <input type="radio" class="custom-control-input bg-primary" name="supplier_type" id="colorCheck1" value="walk-in" checked>
                        <label class="custom-control-label" for="colorCheck1">Walkin</label>
                    </div>
                    <div class="d-inline-block custom-control custom-checkbox mr-1">
                        <input type="radio" class="custom-control-input bg-purple" name="supplier_type" value="supplier" id="colorCheck3">
                        <label class="custom-control-label" for="colorCheck3">{{trans('suppliers.supplier')}}</label>
                    </div>
                </div>
                <div class="col-2">
                    <label for="prefered">Pre. Supplier</label>
                    <select name="preffered" id="preffered" class="form-control">
                        <option value="">--Choose--</option>
                        <option value="all">All</option>
                        <option value="preffered">Preffered</option>
                    </select>
                </div>
                <div class="col-2">
                    <label for="item_type">Item Type</label>
                    <select name="item_types" id="item_type" class="form-control">
                        <option value="">Default</option>
                        <option value="paper">Paper</option>
                        <option value="other_items">Other Items</option>
                    </select>
                </div>
                <div class="col-4">
                    <label for="payer" class="caption">Search Supplier</label> 
                    <a href="{{ route('biller.suppliers.create') }}" class="btn btn-blue btn-sm round float-right add-supplier">
                        <i class="fa fa-plus-circle"></i> supplier
                    </a>                                     
                    <select class="form-control" id="supplierbox" data-placeholder="Search Supplier" disabled></select>
                    <input type="hidden" name="supplier_id" value="{{ @$purchase->supplier_id ?: 1 }}" id="supplierid">
                </div>
            </div>
            
            <div class="form-group row">
                <div class="col-sm-8">
                    <label for="payer" class="caption">Supplier Name*</label>
                    <div class="input-group ">
                        <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>                                            
                        {{ Form::text('suppliername', null, ['class' => 'form-control round', 'placeholder' => 'Supplier Name', 'id' => 'supplier', 'required']) }}
                    </div>
                </div>
                
            </div>

            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="taxFormat" class="caption">Tax</label>
                    <select class="form-control" name="tax" id="tax">
                        @foreach ($additionals as $tax)
                            <option value="{{ (int) $tax->value }}" {{ $tax->value ? 'selected' : ''}}>
                                {{ $tax->name }} 
                            </option>
                        @endforeach                                                    
                    </select>
                </div>
                <div class="col-sm-4">
                    <div><label for="vat_on_amount">Tax on Amount</label></div>
                    <div class="d-inline form-check mr-1">
                        <input type="radio" class="form-check-input bg-primary is_tax_exc" name="is_tax_exc" value="1" id="tax_exc" checked>
                        <label for="exclusive">Exclusive</label>
                    </div>
                    <div class="d-inline form-check">
                        <input type="radio" class="form-check-input bg-purple is_tax_exc" name="is_tax_exc" value="0" id="tax_inc">
                        <label for="inclusive">Inclusive</label>
                    </div>
                </div>
                <div class="col-4">
                    <label for="currency">Currency</label>
                    <div class="input-group row no-gutters">
                        <select name="currency_id" class="form-control currency" id="currency">
                            @foreach ($currency as $rate)
                                <option value="{{ $rate->id }}" data-rate="{{numberClean($rate->rate)}}" data-code="{{$rate->code}}" {{ @$purchase->currency == $rate->id ? 'selected' : ''}}>{{ $rate->code }}</option>
                            @endforeach
                        </select>
                        {{ Form::text('currency_rate', null, ['class' => 'form-control currency_rate', 'id' => 'currency_rate','required']) }}
                    </div>
                </div>
                {{-- <div class="col-4">
                    <label for="currency_rate">Currency Rate</label>
                    
                </div> --}}
                
            </div>

            
        </div>
    </div>

    <div class="col-sm-6 cmp-pnl">
        <div class="inner-cmp-pnl">
            <h3 class="title">{{trans('purchaseorders.properties')}}</h3>
            <div class="form-group row">
                {{-- <div class="col-sm-4">
                    <label for="tid" class="caption">Transaction ID*</label>
                    <div class="input-group">
                        <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>
                        {{ Form::number('tid', @$purchase? $purchase->tid : $last_tid+1, ['class' => 'form-control round', 'readonly']) }}
                    </div>
                </div> --}}
                <div class="col-sm-4">
                    <label for="lpo_include" class="caption">LPO/ NO LPO</label>
                    <select class="form-control" name="lpo_include" id="lpo_include">
                        <option value="">Default</option>
                        <option value="with_lpo" {{@$purchase->lpo_include == "with_lpo" ? 'selected': ''}}>With LPO</option>
                        <option value="without_lpo" {{@$purchase->lpo_include == "without" ? 'selected': ''}}>Without LPO</option>                                                    
                    </select>
                </div>
                <div class="col-sm-4"><label for="transaction_date" class="caption">Purchase/Order Date*</label>
                    <div class="input-group">                                            
                        {{ Form::text('date', null, ['class' => 'form-control datepicker', 'id' => 'date']) }}
                    </div>
                </div>
                <div class="col-sm-4 doc_ref_type"><label for="ref_type" class="caption">Document Type*</label>
                    <div class="input-group">                                            
                        <select class="form-control" name="doc_ref_type" id="ref_type">
                            <option value="">-- Select Type --</option>
                            @foreach (['Invoice', 'Receipt', 'DNote', 'Voucher'] as $val)
                                <option value="{{ $val }}">{{ $val }}</option>
                            @endforeach                                                        
                        </select>
                    </div>
                </div>
                {{-- <div class="col-sm-4 validity d-none"><label for="validity" class="caption">Validity*</label>
                    <div class="input-group">                                            
                        {{ Form::number('validity', null, ['class' => 'form-control', 'id' => 'validity']) }}
                    </div>
                </div> --}}
                <div class="col-4 validity d-none"><label for="validity" >Validity Period</label>
                <div class="input-group">
                    <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>
                    <select class="custom-select round" name="validity" id="validity">
                        @php
                            $selected = '';
                        @endphp
                        @foreach ([0, 14, 30, 45, 60, 90] as $val)
                            @php
                                if (isset($purchase)) $selected =  $val == @$purchase->validity? 'selected' : '';
                                else $selected = $val == 0? 'selected' : '';
                            @endphp
                            <option value="{{ $val }}" {{ $selected }}>
                                {{ $val ? 'Valid For '.$val.' Days' : 'On Receipt' }}
                            </option>
                        @endforeach                                                
                    </select>
                </div>
            </div>      
                
                
            </div>

            <div class="form-group row">
                <div class="col-sm-4"><label for="taxid" class="caption">Tax PIN</label>
                    <div class="input-group">
                        <div class="input-group-addon"><span class="icon-bookmark-o" aria-hidden="true"></span></div>
                        {{ Form::text('supplier_taxid', null, ['class' => 'form-control round', 'placeholder' => 'e.g PO515725965', 'id'=>'taxid']) }}
                    </div>
                </div>
                <div class="col-sm-4 doc_ref">
                    <label for="refer_no" class="caption">{{trans('general.reference')}} No.</label>
                    <div class="input-group">
                        <div class="input-group-addon"><span class="icon-bookmark-o" aria-hidden="true"></span></div>                                            
                        {{ Form::text('doc_ref', null, ['class' => 'form-control round', 'placeholder' => trans('general.reference'), 'id'=>'doc_ref']) }}
                    </div>
                </div>
                <div class="col-3 terms">
                    <label for="terms">Terms</label>
                    <select name="term_id" class="form-control" id="terms">
                        @foreach ($terms as $term)
                            <option value="{{ $term->id }}" {{ $term->id == @$po->term_id ? 'selected' : ''}}>
                                {{ $term->title }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                
                {{-- <div class="col-sm-4">
                    <label for="document_type" class="caption">Item Type</label>
                    <select class="form-control" name="document_type" id="item-type">
                        <option value="direct_expense" {{@$purchase->document_type == "direct_expense" ? 'selected': ''}}>Expense</option>
                        <option value="direct_stock" {{@$purchase->document_type == "direct_stock" ? 'selected': ''}}>Requisition Items</option>                                                    
                    </select>
                </div> --}}
            </div>
            <div class="form-group row">
                <div class="col-12">
                    <label for="toAddInfo" class="caption">{{trans('general.note')}}*</label>
                    {{ Form::textarea('note', null, ['class' => 'form-control', 'placeholder' => trans('general.note'), 'rows'=>'2', 'required']) }}
                </div>
            </div>
            {{ Form::hidden('tid', @$purchase? $purchase->tid : $last_tid+1, ['class' => 'form-control round', 'readonly']) }}
        </div>
    </div>
</div>

<!-- Tab Menus -->
@include('focus.purchaseorders.partials.requisition')
<div class="form-group float-right">
    <div class="bg-white form-group row">
        <div class="col-8">
            <label><b>{{trans('general.total_tax')}}</b></label>                   
             <span id="invtax" class="lightMode form-control">0</span>
        </div>
    </div>
    <div class="bg-white form-group row">
        {{-- <h4>Total</h4> --}}
        <div class="col-8">
            <label for="total">Total</label>
            <input type="text" class="form-control" name="total" value="0.00" id="stock_grandttl" readonly>
            <input type="hidden" name="subtotal" value="0.00" id="stock_subttl">
            <input type="hidden" name="taxable" value="0.00" id="stock_tax">
            <input type="hidden" name="frx_taxable" value="0.00" id="fx_taxable">
            <input type="hidden" name="frx_total" value="0.00" id="fx_total">
            <input type="hidden" name="frx_subtotal" value="0.00" id="fx_subtotal">
    
        </div>
    </div>
    {{ Form::submit('POST TRANSACTION', ['class' => 'btn btn-success sub-btn btn-lg']) }}
</div>
<input type="hidden" name="supplier_type" value="supplier">
{{ Form::hidden('document_type', 'requisition_stock', ['class' => 'form-control']) }}