@extends ('core.layouts.app')

@section ('title', 'Purchase Order Expense Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4>Purchase Order Expense Management</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.purchaseorders.partials.purchaseorders-header-buttons')
                </div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <h5 class="card-header">
            @php
                $po = $purchaseorder;
                $valid_token = token_validator('', 'po' . $po->id, true);
                $link = route('biller.print_purchaseorder', [$po->id, 9, $valid_token, 1]);
            @endphp
            <a href="{{ $link }}" class="btn btn-purple btn-sm" target="_blank">
                <i class="fa fa-print" aria-hidden="true"></i> Print
            </a>
            <a href="#" class="btn btn-warning btn-sm mr-1" data-toggle="modal" data-target="#approveModal">
                <i class="fa fa-pencil" aria-hidden="true"></i> Status
            </a>
        </h5>
        <div class="card-body">            
            <ul class="nav nav-tabs nav-top-border no-hover-bg nav-justified" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="active-tab1" data-toggle="tab" href="#active1" aria-controls="active1" role="tab" aria-selected="true">
                        Purchase Order Details
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link " id="active-tab2" data-toggle="tab" href="#active2" aria-controls="active2" role="tab">
                        Expense Items
                    </a>
                </li>
            </ul>

            <div class="tab-content px-1 pt-1">
                <!-- PO details -->
                <div class="tab-pane active in" id="active1" aria-labelledby="customer-details" role="tabpanel">
                    <table id="customer-table" class="table table-sm table-bordered zero-configuration" cellspacing="0" width="100%">
                        <tbody>  
                            @php   
                                $project = $po->project ? gen4tid('Prj-', $po->project->tid) . '; ' . $po->project->name : '';
                                $details = [
                                    'Supplier' => $po->supplier->name,
                                    'Transaction ID' => $po->tid,
                                    'Date & Due Date' => dateFormat($po->date) . ' : ' . dateFormat($po->due_date),
                                    'Reference' =>$po->doc_ref_type . ' - ' . $po->doc_ref,
                                    'Note' => $po->note,
                                ];                       
                            @endphp
                            @foreach ($details as $key => $val)
                                <tr>
                                    <th>{{ $key }}</th>
                                    <td>{{ $val }}</td>
                                </tr>
                            @endforeach                            
                            <tr>
                                <th>Order Items Cost</th>
                                <td>
                                    <b>Purchase Order:</b>   {{ amountFormat($po->total) }}<br>
                                    
                                </td>
                            </tr>                              
                        </tbody>
                    </table>            
                </div>

                <!-- Inventory/stock -->
                <div class="tab-pane" id="active2" aria-labelledby="equipment-maintained" role="tabpanel">
                    <table class="table table-lg table-bordered zero-configuration" cellspacing="0" width="100%">
                        <tr>
                            <th>Product Description</th>
                            <th>Quantity</th>
                            <th>UoM</th>
                            <th>Price</th>
                            <th>Tax Rate</th>                            
                            <th>Amount</th>
                        </tr>
                        <tbody>
                            @foreach ($po->products as $item)
                                {{-- @if ($item->type == 'Stock') --}}
                                    <tr>
                                        <td>{{ $item->name }}</td>
                                        <td>{{ number_format($item->qty, 1) }}</td>
                                        <td>{{ $item->uom }}</td>
                                        <td>{{ number_format($item->purchase_price, 2) }}</td>                                        
                                        <td>{{ number_format($item->tax_rate, 2) }}</td>
                                        <td>{{ number_format($item->total, 2) }}</td>
                                    </tr>
                                {{-- @endif --}}
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
        @include('focus.purchaseorders.partials.approve-status')
    </div>
</div>
@endsection