{{ Html::script('focus/js/select2.min.js') }}
<script>
    // initialize html editor

    // ajax config
    $.ajaxSetup({headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" }});

    $('#customer').select2({allowClear: true});
    $('#currency_rate').val(1).attr('readonly',true)

    // initialize datepicker
    $('.datepicker').datepicker({format: "{{ config('core.user_date_format') }}", autoHide: true})
    $('#referencedate').datepicker('setDate', new Date());
    $('#date').datepicker('setDate', new Date());

    // print type
    $('input[type=radio]').change(function() {
        if ($(this).val() == 'inclusive') $('#vatText').text('(Print VAT-Inc)');
        else $('#vatText').text('(Print VAT-Exc)');
    });

    // On change lead and djc
    const subject = {title: '', djc: ''};
    $('form').on('change', '#customer, #reference', function() {
        if ($(this).is('#customer')) {
            const opt = $('#customer option:selected');
            $('#attention').val(opt.attr('assign_to'));
            $('#subject').val(opt.attr('title'));
            $('#client_ref').val(opt.attr('client_ref'));
            $('#branch_id').val(opt.attr('branch_id'));
            $('#customer_id').val(opt.attr('customer_id'));
            subject.title = opt.attr('title');

            // update price customer based on selected lead
            let priceCustomer = '';
            $('#price_customer option').each(function () {
                if (opt.attr('customer_id') == $(this).val())
                priceCustomer = $(this).val();
            });
            $('#price_customer').val(priceCustomer);

        } else subject.djc = $(this).val();
        // subject
        if (subject.title && subject.djc) $('#subject').val(subject.title + ' ; Djc-' + subject.djc);
        else if (subject.title) $('#subject').val(subject.title);
    });

    // calculate profit
    const profitState = {sp_total: 0, bp_subtotal: 0, skill_total: 0, bp_total: 0};
    function calcProfit() {
        const {sp_total, bp_total, skill_total} = profitState;
        const profit = sp_total - (bp_total + skill_total);
        let pcent_profit = profit/(bp_total + skill_total) * 100;
        pcent_profit = isFinite(pcent_profit) ? Math.round(pcent_profit) : 0;

        const profitText = bp_total > 0 ?
            `${accounting.formatNumber(profit)} : ${pcent_profit}%` : accounting.formatNumber(profit);
        $('.profit').text(profitText);

        if (profit < 0) $('.profit').removeClass('text-dark').addClass('text-danger');
        else $('.profit').removeClass('text-danger').addClass('text-dark');

        // budget limit 30 percent
        if (sp_total < bp_total * 1.3) $('.budget-alert').removeClass('d-none');
        else $('.budget-alert').addClass('d-none');

        // estimate cost
        $('.estimate-cost').text(accounting.formatNumber(bp_total + skill_total));
    }

    // update row tax options
    function updateLineTax(taxSelect) {
        if (taxSelect && taxSelect.length) {
            const mainTax = $('#tax_id').val();
            taxSelect.children().each(function() {
                const value = $(this).attr('value');
                if ((value == mainTax) || (value == 0)) $(this).removeClass('d-none');
                else $(this).addClass('d-none');
            });
            taxSelect.val(mainTax);
        }
    }

    /**
     * Table logic
     */
    // add title
    let titleId = 2;
    const titleHtml = $("#titleRow").html();
    $("#titleRow").remove();
    $('#addTitle').click(function() {
        $('#quoteTbl tbody tr.invisible').remove();

        const i = 't'+titleId;
        const newTitleHtml = '<tr>' + titleHtml.replace(/t1/g, i) + '</tr>';
        $("#quoteTbl tbody").append(newTitleHtml);
        titleId++;
        calcTotal();
        adjustTbodyHeight();
    });
    //add paper
    // let paperId = 2;
    // const paperHtml = $("#paperRow").html();
    // $("#paperRow").remove();
    // const paperUrl = "{{ route('biller.products.paper_search') }}";
    // $('#product_name-b1').autocomplete(predict(paperUrl, stockSelect));
    // $('#addPaper').click(function () {
    //     $('#bomTbl tbody tr.invisible').remove();

    //     const i = 'b'+paperId;
    //     const newPaperHtml = '<tr>' + paperHtml.replace(/b1/g, i) + '</tr>';
    //     $("#bomTbl tbody").append(newPaperHtml);
    //     $('#product_name-'+i).autocomplete(predict(paperUrl, stockSelect));
    //     paperId++;
    // })
    // add product
    let rowId = 1;
    const rowHtml = $("#productRow").html();
    $('#name-p0').autocomplete(autoComp('p0'));
    $('#addProduct').click(function() {
        $('#quoteTbl tbody tr.invisible').remove();

        const i = 'p' + rowId;
        const newRowHtml = '<tr>' + rowHtml.replace(/p0/g, i) + '</tr>';
        $("#quoteTbl tbody").append(newRowHtml);
        $('#name-'+i).autocomplete(autoComp(i));
        updateLineTax($("#quoteTbl tbody tr:last").find('.tax_rate'));
        // trigger lead change to reset client pricelist
        $('#customer').change();

        adjustTbodyHeight();
        calcTotal();
        rowId++;
    });
    //add Item
    // let itemId = 1;
    // const itemHtml = $('#itemRow').html();
    // const itemUrl = "{{ route('biller.products.purchase_search') }}";
    // $('#product_name-m0').autocomplete(predict(itemUrl,stockSelect));
    // $('#addItem').click(function () {
    //     $('#bomTbl tbody tr.invisible').remove();
    //     const i = 'm' + itemId;
    //     const newItemHtml = '<tr>' + itemHtml.replace(/m0/g, i) + '</tr>';
    //     $("#bomTbl tbody").append(newItemHtml);
    //     $('#product_name-'+i).autocomplete(predict(itemUrl,stockSelect));
    //     itemId++;
    // });
    //Remove items and paper on BomTable
    // $('#bomTbl').on('click', '.remove', function () {
    //     const menu = $(this);
    //     const row = $(this).parents("tr:first");
    //     if (menu.is('.remove') && confirm('Are you sure?')) {
    //         row.remove();
    //         $('#bomTbl tbody tr.invisible').remove();
    //        // adjustTbodyHeight(1);
    //     }
    // })

    // let productNameId = 0;
    // function stockSelect(event, ui) {
    //     const {data} = ui.item;
    //     const i = productNameId;
    //     $('#itemId-'+i).val(data.id);
    //     $('#product_name-'+i).val(data.name);

    //     const purchasePrice = accounting.unformat(data.purchase_price);
    //     $('#purchase_price-'+i).val(accounting.formatNumber(purchasePrice)).change();

    //     $('#uom-'+i).html('');
    //     if(data.uom){
            
    //         $('#uom-'+i).val(data.uom);
    //     }
        
    // }
    // $('#bomTbl').on('mouseup', '.product_name', function() {
    //     const id = $(this).attr('id').split('-')[1];
    //     if ($(this).is('.product_name')) productNameId = id;
    // });  
    // adjust tbody height to accomodate dropdown menu
    function adjustTbodyHeight(rowCount) {
        rowCount = rowCount || $('#quoteTbl tbody tr').length;
        if (rowCount < 4) {
            const rows = [];
            for (let i = 0; i < 5; i++) {
                const tr = `<tr class="invisible"><td colspan="100%"></td><tr>`
                rows.push(tr);
            }
            $('#quoteTbl tbody').append(rows.join(''));
        }
    }

    // add miscellaneous product
    $('#addMisc').click(function() {
        $('#quoteTbl tbody tr.invisible').remove();

        const i = 'p' + rowId;
        const newRowHtml = `<tr class="misc"> ${rowHtml.replace(/p0/g, i)} </tr>`;
        $("#quoteTbl tbody").append(newRowHtml);
        $('#name-'+i).autocomplete(autoComp(i));
        $('#misc-'+i).val(1);
        $('#qty-'+i).val(1);
        ['qty', 'rate', 'price', 'amount', 'lineprofit'].forEach(v => {
            $(`#${v}-${i}`).addClass('invisible');
        });
        rowId++;
        calcTotal();
        adjustTbodyHeight();
    });

    // On clicking action drop down
    $("#quoteTbl").on("click", ".up, .down, .delete, .add-title, .add-product, .add-misc", function() {
        const menu = $(this);
        const row = $(this).parents("tr:first");

        if (menu.is('.up')) row.insertBefore(row.prev());
        if (menu.is('.down')) row.insertAfter(row.next());
        if (menu.is('.delete') && confirm('Are you sure?')) {
            row.remove();
            $('#quoteTbl tbody tr.invisible').remove();
            adjustTbodyHeight(1);
        }

        // dropdown menus
        if (menu.is('.add-title')) {
            $('#addTitle').click();
            const titleRow = $("#quoteTbl tbody tr:last");
            $("#quoteTbl tbody tr:last").remove();
            row.before(titleRow);
        }
        if (menu.is('.add-product')) {
            $('#addProduct').click();
            const productRow = $("#quoteTbl tbody tr:last");
            $("#quoteTbl tbody tr:last").remove();
            row.after(productRow);
            // update tax options
            updateLineTax($("#quoteTbl tbody tr:last").find('.tax_rate'));
        }
        if (menu.is('.add-misc')) {
            $('#addMisc').click();
            const miscRow = $("#quoteTbl tbody tr:last");
            $("#quoteTbl tbody tr:last").remove();
            row.after(miscRow);

        }

        calcTotal();
    });

    // on change qty and rate
    $("#quoteTbl").on("change", ".qty, .rate, .buyprice, .estqty, .tax_rate", function() {
        const id = $(this).attr('id').split('-')[1];

        const qty = accounting.unformat($('#qty-'+id).val());
        const taxrate = accounting.unformat($('#taxrate-'+id).val());
        let buyprice = accounting.unformat($('#buyprice-'+id).val());
        let estqty = accounting.unformat($('#estqty-'+id).val() || '1');
        let rate = accounting.unformat($('#rate-'+id).val());

        // row item % profit
        let price = rate * (taxrate/100 + 1);
        let profit = (qty * rate) - (estqty * buyprice);
        let pcent_profit = profit / (estqty * buyprice) * 100;
        pcent_profit = isFinite(pcent_profit)? Math.round(pcent_profit) : 0;

        $('#buyprice-'+id).val(accounting.formatNumber(buyprice, 4));
        $('#rate-'+id).val(accounting.formatNumber(rate, 4));
        $('#price-'+id).val(accounting.formatNumber(price, 4));
        $('#amount-'+id).text(accounting.formatNumber(qty * price, 4));
        $('#lineprofit-'+id).text(pcent_profit + '%');
        calcTotal();
    });
    // on change qty and rate
    // $("#bomTbl").on("change", ".quantity, .purchase_price", function() {
    //     const id = $(this).attr('id').split('-')[1];

    //     const qty = accounting.unformat($('#quantity-'+id).val());
    //     let rate = accounting.unformat($('#purchase_price-'+id).val());
    //     $('#total_amount-'+id).text(accounting.formatNumber(qty * rate, 4));
    //     calBom();
    // });

    // on tax change
    $('#tax_id').change(function() {
        const mainTax = $(this).val();
        $('#quoteTbl tbody tr').each(function() {
            updateLineTax($(this).find('.tax_rate'));
            if ($(this).find('.qty').val()*1) {
                const itemRate = accounting.unformat($(this).find('.rate').val());
                $(this).find('.price').val(accounting.formatNumber(itemRate * (mainTax/100 + 1), 4));
                $(this).find('.rate').change();
            }
        });
    }).change();

    // compute totals
    function calcTotal() {
        let taxable = 0;
        let total = 0;
        let subtotal = 0;
        let bp_subtotal = 0;
        $("#quoteTbl tbody tr").each(function(i) {
            const isMisc = $(this).hasClass('misc');
            const qty = $(this).find('.qty').val() * 1;
            if (qty > 0) {
                if (!isMisc) {
                    const amount = accounting.unformat($(this).find('.amount').text());
                    const rate = accounting.unformat($(this).find('.rate').val());
                    const taxRate = accounting.unformat($(this).find('.tax_rate').val());
                    if (taxRate > 0) taxable += qty * rate;
                    total += amount;
                    subtotal += qty * rate;
                }
                // profit variables
                const buyprice = accounting.unformat($(this).find('.buyprice').val());
                const estqty = $(this).find('.estqty').val();
                bp_subtotal += estqty * buyprice;
            }
            $(this).find('.index').val(i);
        });
        $('#taxable').val(accounting.formatNumber(taxable));
        $('#total').val(accounting.formatNumber(total));
        $('#subtotal').val(accounting.formatNumber(subtotal));
        $('#tax').val(accounting.formatNumber((total - subtotal)));
        profitState.bp_total = bp_subtotal;
        profitState.sp_total = subtotal;
        calcProfit();
    }
    // compute totals
    // function calBom() {
    //     let total = 0;
    //     $("#bomTbl tbody tr").each(function(i) {
    //         const amount = accounting.unformat($(this).find('.total_amount').text());
    //         total += amount;
    //     });
    //     $('#total_bom').val(accounting.formatNumber(total));
    //     $('#name-p0').val($('#title').val()).attr('readonly', true);
    //     $('#unit-p0').val('Lot').attr('readonly', true);
    //     $('#qty-p0').attr('readonly', true);
    //     $('#buyprice-p0').val(accounting.formatNumber(total)).attr('readonly', true);
    //     $('#type-p0').val(1)
    // }


    /**
     * Skillset modal logic
     */
    // remove skill row
    $('#skillTbl').on('click', '.rem', function() {
        $(this).parents('tr').remove();
        skillTotal();
    });
    $('#skillTbl').on('change', '.type, .chrg, .hrs, .tech', function() {
        const row = $(this).parents('tr');
        let hrs = row.find('.hrs').val();
        let tech = row.find('.tech').val();
        let chrg = row.find('.chrg');

        // labour type charges
        switch (row.find('.type').val()) {
            case 'casual': chrg.val(250).attr('readonly', true); break;
            case 'contract': chrg.val(250).attr('readonly', true); break;
            case 'attachee': chrg.val(150).attr('readonly', true); break;
            case 'outsourced': chrg.val(chrg.val()).attr('readonly', false); break;
        }
        skillTotal();
    });

    // add skill row
    let skillId = 0;
    const skillHtml = $('#skillTbl tbody tr:first').html();
    $('#skillTbl tbody tr:first').remove();
    $('#addRow').click(function() {
        skillId++;
        const html = skillHtml.replace(/-0/g, '-'+skillId).replace('d-none', '');
        $('#skillTbl tbody').append('<tr>'+html+'</tr>');
    });

    function skillTotal() {
        total = 0;
        $('#skillTbl tbody tr').each(function() {
            const hrs = $(this).find('.hrs').val();
            const tech = $(this).find('.tech').val();
            const chrg = $(this).find('.chrg').val();
            const amount = hrs * chrg * tech;
            total += amount;
            $(this).find('.amount').text(amount);
        });
        $('#skill_total').val(accounting.formatNumber(total));
        profitState.skill_total = total;
        calcProfit();
    }
    $('#currency').change(function(e) {
        $('#currency_rate').val('').change();
        const currency = $('#currency').find('option:selected').attr('data-code');
        const rate = $('#currency').find('option:selected').attr('data-rate');
        $('#currency_rate').val(accounting.unformat(rate));
        if (currency == "TSH") {
           // $('#currency_rate').val(1);
            $('#currency_rate').attr('readonly', true);
           
        }else{

            $('#currency_rate').attr('readonly', false);
        }
    })

    // function predict(url, callback) {
    //     return {
    //         source: function(request, response) {
    //             $.ajax({
    //                 url,
    //                 dataType: "json",
    //                 method: "POST",
    //                 data: {keyword: request.term, pricegroup_id: $('#pricegroup_id').val()},
    //                 success: function(data) {
    //                     response(data.map(v => ({
    //                         label: v.name,
    //                         value: v.name,
    //                         data: v
    //                     })));
    //                 }
    //             });
    //         },
    //         autoFocus: true,
    //         minLength: 0,
    //         select: callback
    //     };
    // }

    // autocomplete function
    function autoComp(i) {
        return {
            source: function(request, response) {
                // stock product
                let term = request.term;
                let url = "{{ route('biller.products.quote_product_search') }}";
                let data = {
                    keyword: term,
                    price_customer_id: $('#price_customer').val(),
                };
                // maintenance service product
                const docType = @json(request('doc_type'));
                if (docType == 'maintenance') {
                    url = "{{ route('biller.taskschedules.quote_product_search') }}";
                    data.customer_id = $('#customer option:selected').attr('customer_id');
                }
                $.ajax({
                    url, data,
                    method: 'POST',
                    success: result => response(result.map(v => ({label: v.name, value: v.name, data: v}))),
                });
            },
            autoFocus: true,
            minLength: 0,
            select: function(event, ui) {
                const {data} = ui.item;

                $('#productid-'+i).val(data.id);
                $('#name-'+i).val(data.name);
                
                $('#qty-'+i).val(1);
                //console.log(data.unit.code);

                const currencyRate = $('#currency option:selected').attr('currency_rate');
                if (currencyRate > 1) {
                    data.purchase_price = parseFloat(data.purchase_price) / currencyRate;
                    data.price = parseFloat(data.price) / currencyRate;
                }

                $('#buyprice-'+i).val(accounting.formatNumber(data.purchase_price));
                $('#estqty-'+i).val(1);

                const rate = parseFloat(data.price);
                let price = rate * ($('#tax_id').val()/100 + 1);
                $('#price-'+i).val(accounting.formatNumber(price));
                $('#amount-'+i).text(accounting.formatNumber(price));
                $('#rate-'+i).val(accounting.formatNumber(rate)).change();

                if (data.units) {
                    let units = data.units.filter(v => v.unit_type == 'base');
                    if (units.length) $('#unit-'+i).val(units[0].code);
                }
                if(data.unit){
                    $('#unit-'+i).val(data.unit.code);
                }
            }
        };
    }
</script>
