@extends ('core.layouts.app')

@php
    $header_title = trans('labels.backend.quotes.management');
    $is_pi = request('page') == 'pi';
    $task = request('task');
    if ($is_pi) $header_title = 'Work Order Management';
@endphp


@section('title', 'Edit | ' . $header_title)

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="alert alert-warning col-12 d-none budget-alert" role="alert">
            <strong>E.P Margin Not Met!</strong> Check line item rates.
        </div>
        <div class="content-header-left col-6">
            <h4 class="content-header-title">{{ $header_title }}</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                @include('focus.quotes.partials.quotes-header-buttons')
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            @if ($task)
            <a href="#" class="btn btn-warning btn-sm mr-1" data-toggle="modal" data-target="#extrasModal">
                <i class="fa fa-pencil" aria-hidden="true"></i>Add Details
            </a>
            @endif
        </div>
        <div class="card-body">
            @if ($task)
                {{ Form::model($quote, ['route' => ['biller.quotes.store_workorder', $quote], 'method' => 'post']) }}
                    @include('focus.quotes.form')
                    @include('focus.quotes.partials.extras_modal')
                {{ Form::close() }}
            @else
                
            {{ Form::model($quote, ['route' => ['biller.quotes.update', $quote], 'method' => 'patch']) }}
                    @include('focus.quotes.form')
            {{ Form::close() }}
            @endif
        </div>
    </div> 
    
</div>
@endsection

@section('extra-scripts')
    @include('focus.quotes.edit_js')
@endsection