@extends ('core.layouts.app')

@section ('title', 'Request For Dispatch Management' . ' | ' . 'view')

@section('page-header')
    <h1>
        {{ 'Request For Dispatch Management' }}
        <small>{{ 'view' }}</small>
    </h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h3 class="content-header-title mb-0">View RFD</h3>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        <div class="media-body media-right text-right">
                            @include('focus.request_dispatchs.partials.request_dispatchs-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <a href="#" class="btn btn-warning btn-sm mr-1" data-toggle="modal" data-target="#statusModal">
                                    <i class="fa fa-pencil" aria-hidden="true"></i>Approval Status
                                </a>
                            </div>

                            <div class="card-content">

                                <div class="card-body">


                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Request Dispatch No.</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{gen4tid('RFD-',$request_dispatch['tid'])}}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Customer</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{@$request_dispatch->customer['company']}}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Date</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{dateFormat($request_dispatch['date'])}}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Item Type</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{$request_dispatch['item_type']}}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Description</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{$request_dispatch['description']}}</p>
                                        </div>
                                    </div>


                                </div>

                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr class="item_header bg-gradient-directional-blue white ">
                                                <th width="15%" class="text-center">JobCard/Product</th>
                                                <th width="10%" class="text-center">Box/Bundle</th>
                                                <th width="10%" class="text-center">No. Of Bundles</th>
                                                <th width="10%" class="text-center">Date & Time</th>
                                                <th width="10%" class="text-center">Total Qty</th>
                                                <th width="10%" class="text-center">Balance In Stock</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($request_dispatch->items as $item)
                                                <tr class="text-center">
                                                    <td>{{$item->name}}</td>
                                                    <td>{{$item->box_bundle}}</td>
                                                    <td>{{$item->no_of_bundle}}</td>
                                                    <td>{{datetime_for_database($item['datetime'])}}</td>
                                                    
                                                    <td>{{+$item->total_qty}}</td>
                                                    <td>{{+$item->balance_instock}}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('focus.request_dispatchs.partials.approval')
    </div>
@endsection
@section('extra-scripts')
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
        
    };

    const Form = {
        requestDispatch: @json(@$request_dispatch),
        rowIds: 0,
        tableRow: $('#requisitionTbl tbody tr:first').html(),
        stockUrl: "{{ route('biller.products.waste_search') }}",
        jobcardUrl: "{{ route('biller.products.jobcard_search') }}",

        init() {
            $.ajaxSetup(config.ajax);
            $('#employee').select2({allowClear: true});
            $('.datepicker').datepicker(config.date);
           
            
            
        },
       
    };

    $(() => Form.init());
</script>
@endsection