@extends ('core.layouts.app')
@php
    // $header_title = trans('labels.backend.quotes.management');
    $is_pi = request('page') == 'pi';
    $task = request('task');
    // if ($is_pi) $header_title = 'Proforma Invoice Management';
@endphp

@section ('title', 'Request For Quotation')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Request For Quotation</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.request_quotations.partials.request_quotations-header-buttons')
                </div>
            </div>
        </div>
    </div>
    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            @if ($task)
                            {{ Form::model($request_quotations,['route' => ['biller.request_quotations.store', $request_quotations], 'method' => 'post', 'id' => 'create-request_quotations']) }}
                                @include("focus.request_quotations.form")
                                <div class="edit-form-btn">
                                    {{ link_to_route('biller.request_quotations.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                    {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-primary btn-md']) }}
                                    <div class="clearfix"></div>
                                </div>
                                {{ Form::close() }}
                            @else
                                {{ Form::model($request_quotations, ['route' => ['biller.request_quotations.update', $request_quotations], 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'PATCH', 'id' => 'edit-request_quotations']) }}
                                    @include("focus.request_quotations.form")
                                    <div class="edit-form-btn">
                                        {{ link_to_route('biller.request_quotations.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                        {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-primary btn-md']) }}
                                        <div class="clearfix"></div>
                                    </div>
                                {{ Form::close() }}
                            @endif
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('extra-scripts')
    @include('focus.request_quotations.edit_js')
@endsection