@extends ('core.layouts.app')

@section ('title', 'Request For Quotations')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Request For Quotations</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.request_quotations.partials.request_quotations-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <table id="brands-table" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>RFQ No.</th>
                                        <th>Date</th>
                                        <th>Due Date</th>
                                        <th>Description</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
<script>
    const config = {
        ajaxSetup: {
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        }
    };

    const Index = {
        init() {
            $.ajaxSetup(config.ajaxSetup);
            this.drawDataTable();
        },

        drawDataTable() {
            $('#brands-table').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                language: { @lang('datatable.strings')},
                ajax: {
                    url: '{{ route("biller.request_quotations.get") }}',
                    type: 'post'
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    {data: 'tid', name: 'tid'},
                    {data: 'date', name: 'date'},
                    {data: 'due_date', name: 'due_date'},
                    {data: 'note', name: 'note'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print']
            });
        }
    }

    $(() => Index.init());
</script>
@endsection
