@extends ('core.layouts.app')
@section ('title', 'Request For Quotations')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h3 class="content-header-title">Request For Quotations</h3>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.request_quotations.partials.request_quotations-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-header">
                            
                            <a href="#" class="btn btn-purple btn-sm mr-1" data-toggle="modal" data-target="#statusModal">
                                <i class="fa fa-print" aria-hidden="true"></i>Print
                            </a>
                        </div>
                        <div class="card-body">
                            <div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Name
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                       {{$request_quotation->title}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Reference Number
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ gen4tid('RFQ-',$request_quotation->tid) }}
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Dated
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                       {{dateFormat($request_quotation->date)}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Due Date
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                       {{dateFormat($request_quotation->due_date)}}
                                    </div>
                                </div>
                                
                                
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Created on
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ dateFormat($request_quotation->created_at) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Description
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $request_quotation->note }}</div>
                                </div>
                            </div>
                            {{-- <div class="container"> --}}
                                <br><br>
                                <div class="content-header-left col-6">
                                    <h4 class="content-header-title">Request For Quotation Items</h4>
                                </div>
                                <br><br>
                                <table class="table table-bordered">
                                    <thead>
                                        <th>#</th>
                                        <th>Product</th>
                                        <th>Quantity</th>
                                        <th>Unit Of Measure</th>
                                       


                                    </thead>
                                    <tbody>
                                        @foreach ($request_quotation->items as $k => $item)
                                            <tr>
                                                <td>{{$k+1}}</td>
                                                <td>{{$item->product}}</td>
                                                <td>{{NumberFormat($item->product_quantity)}}</td>
                                                <td>{{$item->uom}}</td>
                                                
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            {{-- </div> --}}
                            <br><br>
                                <div class="content-header-left col-6">
                                    <h4 class="content-header-title">Request For Quotation Suppliers</h4>
                                </div>
                                <br><br>
                                <table class="table table-bordered">
                                    <thead>
                                        <th>#</th>
                                        <th>Supplier Name</th>
                                        
                                       


                                    </thead>
                                    <tbody>
                                        @foreach ($request_quotation->request_supplier as $k => $item)
                                            <tr>
                                                <td>{{$k+1}}</td>
                                                <td>{{$item->supplier ? $item->supplier->name : ''}}</td>
                                                
                                                
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
   @include('focus.request_quotations.partials.approval')
</div>
@endsection
@section('after-scripts')
{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
        ajaxSetup: {
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        }
    };

    const Index = {
        init() {
            $.ajaxSetup(config.ajaxSetup);
           $('#supplier').select2({allowClear: true});
        },
    };
    $(() => Index.init());
</script>
@endsection