@extends ('core.layouts.app')

@section('title', 'Create | Stock Adjustment Management')


@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Stock Adjustment Management</h4>
        </div>
        <div class="col-6">
            <div class="btn-group float-right">
                @include('focus.stock_adjustment.partials.stock-adjustment-header-buttons')
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    {{ Form::open(['route' => 'biller.stock-adjustment.store', 'method' => 'POST']) }}
                        @include('focus.stock_adjustment.form')

                        <div class="">
                            <br>
                            {{ link_to_route('biller.stock-adjustment.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                            {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-primary btn-md']) }}
                            <div class="clearfix"></div>
                        </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section("extra-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">

        const config = {
            ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
            date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
            predict: (url, callback) => {
                return {
                    source: function(request, response) {
                        $.ajax({
                            url,
                            dataType: "json",
                            method: "POST",
                            data: {keyword: request.term, projectstock: $('#projectstock').val()},
                            success: function(data) {
                                response(data.map(v => ({
                                    label: v.name,
                                    value: v.name,
                                    data: v
                                })));
                            }
                        });
                    },
                    autoFocus: true,
                    minLength: 0,
                    select: callback
                };
            }
        };

        const Form = {
            rowIds: 0,
            tableRow: $('#stockAdjustmentTable tbody tr:first').html(),
            stockUrl: "{{ route('biller.products.purchase_search') }}",
            paperUrl: "{{ route('biller.products.select') }}",
            init(){
                $.ajaxSetup(config.ajax);
                 $('.datepicker').datepicker(config.date).datepicker('setDate', new Date())

                $('#stockAdjustmentTable tbody tr:first').remove();
                $('#item_type').change(function () { 
                    if ($(this).val() == 'paper') {
                        $('#stockAdjustmentTable tbody').html('');
                        $('.name').autocomplete(config.predict(this.paperUrl, Form.paperSelect));
                    }
                    else if ($(this).val() == 'other_items') {
                        $('#stockAdjustmentTable tbody').html('');
                        $('.name').autocomplete(config.predict(this.stockUrl, Form.stockSelect));
                    }
                });
                
                
                $('#addstock').click(this.addItem);
                $('#stockAdjustmentTable').on('click', '.remove', this.removeRow);
            },

            addItem() {
                Form.rowIds++;
                let i = Form.rowIds;
                const html = Form.tableRow.replace(/-0/g, '-'+i);
                $('#stockAdjustmentTable tbody').append('<tr>' + html + '</tr>');
            // $('.name').autocomplete(config.predict(Form.stockUrl, Form.stockSelect));
                if ($('#item_type').val() == 'paper') {
                    $('.name').autocomplete(config.predict(Form.paperUrl, Form.paperSelect));
                }
                else if ($('#item_type').val() == 'other_items') {
                    $('.name').autocomplete(config.predict(Form.stockUrl, Form.stockSelect));
                }
            // $('#stockAdjustmentTable').on('change','.deduct', deduct);
            },
            removeRow() {
                const $tr = $(this).parents('tr:first');
                $tr.remove();
            },
            stockSelect(event, ui) {
                const {data} = ui.item;
                // console.log(ui);
                const i =  Form.rowIds;
                $('#item-id-'+i).val(data.id);
                $('#name-'+i).val(data.name);
                $('#qty_stock-'+i).val(data.qty_stock);
                $('#supplier_id-'+i).val(data.supplier_id);
                $('#sku-'+i).val(data.sku);
                $('#type-'+i).val('other_items');

                if(data.uom){
                    $('#uom-'+i).val(data.uom);
                    $('#unit-'+i).val(data.unit);
                }
                
            },
            paperSelect(event, ui) {
                const {data} = ui.item;
                console.log(data);
                const i =  Form.rowIds;
                $('#item-id-'+i).val(data.id);
                $('#name-'+i).val(data.name);
                $('#qty_stock-'+i).val(data.qty_stock);
                $('#supplier_id-'+i).val(data.supplier_id);
                $('#sku-'+i).val(data.sku);
                $('#type-'+i).val('paper');


                if(data.uom){
                    $('#uom-'+i).val(data.uom);
                    $('#unit-'+i).val(data.unit);
                }
                
            },
        };
        $(()=>Form.init());
    </script>
@endsection