@extends ('core.layouts.app')

@section('title', 'View | Stock Adjustment Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Stock Adjustment Management</h4>
        </div>
        <div class="col-6">
            <div class="btn-group float-right">
                @include('focus.stock_adjustment.partials.stock-adjustment-header-buttons')
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <div class="container">

                        <div class="btn-group m-2" role="group" aria-label="quotes">
                            @if ($stockAdjustment->status == 0)
                                <a href="{{route('biller.sa.approve',[$stockAdjustment->id])}}" class="btn btn-info ml-1">
                                    <i class="fa fa-list-alt"></i> Approve
                                </a>                        <br>

                                <a href="{{route('biller.stock-adjustment.edit',[$stockAdjustment->id])}}" class="btn btn-success ml-1">
                                    <i class="fa fa-list-alt"></i> Edit
                                </a>                        <br>

                            @else
                                <a href="#" class="btn btn-success  btn-lighten-3">
                                    <i class="fa fa-plus-circle"></i> Approved
                                </a>                        <br>

                            @endif
                        </div>


                        <div class="row">
                            <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                Stock Adjustment No:
                            </div>
                            <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                               ST-AD-{{$stockAdjustment->tid}}
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                Adjustment Date
                            </div>
                            <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                {{ dateFormat($stockAdjustment->date ) }}
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                Notes
                            </div>
                            <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                {{ $stockAdjustment->notes }}</div>
                        </div>

                    </div>
                    <div class="table-responsive">
                        <table class="table tfr my_stripe_single text-center" id="productsTbl">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="25%">Product</th>
                                    <th width="10%">Initial Quantity</th>
                                    <th width="10%">Final Quantity</th>
                                    {{-- <th>UoM</th> --}}
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($stockAdjustment->items as $i => $item)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->product->name }}</td>
                                        <td>{{ $item->current_stock_quantity }}</td>
                                        <td>{{ $item->new_qty }}</td>
                                        {{-- <td>{{ $item->uom }}</td> --}}
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
