@extends ('core.layouts.app')

@section ('title', 'Edit | Warehouse Row')

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row mb-2">
                <div class="content-header-left col-md-6 col-12">
                    <h4 class="content-header-title mb-0">Edit Warehouse Row</h4>
                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">
                        <div class="media-body media-right text-right">
                            @include('focus.warehouses.partials.warehouses-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <div class="card-content">

                                <div class="card-body">
                                    {{ Form::model($warehouse_row, ['route' => ['biller.warehouse-rows.update', $warehouse_row], 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'PATCH', 'id' => 'edit-warehouse-row']) }}

                                    <div class="form-group">
                                        {{-- Including Form blade file --}}
                                        @include("focus.warehouses.warehouse_rows.edit_form")
                                        <div class="edit-form-btn">
                                            {{ link_to_route('biller.warehouse-rows.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                            {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-primary btn-md']) }}
                                            <div class="clearfix"></div>
                                        </div><!--edit-form-btn-->
                                    </div><!--form-group-->

                                    {{ Form::close() }}
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
