@extends ('core.layouts.app')

@section('title', trans('labels.backend.warehouses.management'))

@section('content')
    <div class="content-wrapper">
        <div class="content-header row mb-2">
            <div class="content-header-left col-6">
                {{-- <h3 class="content-header-title">{{ trans('labels.backend.warehouses.view') }}</h3> --}}
                <h3 class="content-header-title">{{ 'Warehouse Row' }}</h3>
            </div>
            <div class="content-header-right col-6">
                <div class="media width-250 float-right">
                    <div class="media-body media-right text-right">
                        @include('focus.warehouses.warehouse_rows.partials.warehouses-row-header-buttons')
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body pl-3 pr-3">
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        {{-- <p>{{ trans('warehouses.extra') }}</p> --}}
                                        <p>{{ 'Warehouse' }}</p>
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        <p> {{ $warehouse_row->extra }}</p>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        {{-- <p>{{ trans('warehouses.title') }} </p> --}}
                                        <p>{{ 'Row Number' }} </p>
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        <p>
                                            {{ $warehouse_row->row_number }}
                                            {{-- <a class="btn btn-purple round" href="{{ route('biller.products.index', ['warehouse_row_id' => $warehouse_row->id]) }}" title="products">
                                                <i class="fa fa-list"></i>
                                            </a> --}}
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        {{-- <p>{{ trans('warehouses.extra') }}</p> --}}
                                        <p>{{ 'Number of shelves' }}</p>
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        <p> {{ $warehouse_row->row_number }}</p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        {{-- <p>{{ trans('warehouses.extra') }}</p> --}}
                                        <p>{{ 'Row Description' }}</p>
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        <p> {{ $warehouse_row->extra }}</p>
                                    </div>
                                </div>
                                {{-- <div class="row"> --}}
                                    {{-- <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        <p>{{ trans('productcategories.total_products') }}</p>
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        <p>{{ numberFormat($warehouse->products->sum('qty')) }}</p>
                                    </div>
                                </div> --}}
                                {{-- <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        <p>{{ trans('productcategories.total_worth') }}</p>
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        <p>{{ amountFormat($warehouse->products->sum('total_value')) }}</p>
                                    </div>
                                </div> --}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
