@extends ('core.layouts.app')

@section ('title', 'Work Order Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Work Order Management</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.work_orders.partials.work-order-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <table id="workOrderTbl" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>#Order No.</th>
                                        <th>Customer</th>
                                        <th>Note</th>
                                        <th>Date</th>
                                        <th>Due Date</th>
                                        <th>Amount</th>
                                        <th>Approval</th>
                                        <th>Invoice</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="100%" class="text-center text-success font-large-1">
                                            <i class="fa fa-spinner spinner"></i>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}" }}
    };

    const Index = {
        status: '',
        warehouseId: @json(request('warehouse_id')),
        categoryId: @json(request('productcategory_id')),
        wasteDateId: @json(request('waste_date')),

        init() {
            Index.drawDataTable();
            $('#status').change(Index.statusChange);
        },

        statusChange() {
            Index.status = $(this).val();
            $('#workOrderTbl').DataTable().destroy();
            return Index.drawDataTable();
        },

        drawDataTable() {
            $('#workOrderTbl').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                stateSave: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: '{{ route("biller.work_orders.get") }}',
                    type: 'post',
                    data: {
                        warehouse_id: Index.warehouseId,
                        category_id: Index.categoryId,
                        status: Index.status,
                        waste_date: Index.wasteDateId,
                    },
                    dataSrc: ({data}) => {
                        if (data[0]) {
                            const aggr = data[0].aggregate;
                            
                        }
                        return data;
                    },
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    ...[
                        'tid', 'customer_id', 'note', 'date', 'due_date', 'total', 'status', 'inv_status'
                    ].map(v => ({data: v, name: v})),
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print']
            });
        },
    };

    $(Index.init);
</script>
@endsection
