<?php

// work orders
Route::group(['namespace' => 'work_order'], function() {
    Route::get('work_orders/approved', 'WorkOrderController@approved_work_order')->name('work_orders.approved_work_order');
    Route::post('work_orders/get_approved', 'ApprovedWorkOrderTableController')->name('work_orders.get_approved');

    Route::post('work_orders/status', 'WorkOrderController@status_update')->name('work_orders.status_update');
    Route::post('work_orders/get', 'WorkOrderTableController')->name('work_orders.get');
    Route::resource('work_orders', 'WorkOrderController');

    Route::get('work-order/to/pi/{id}', 'WorkOrderController@viewPI')->name('pi.view');
    Route::get('work-order/{id}/approve', 'WorkOrderController@approveWorkOrder')->name('work-order.approve');
    Route::get('work-order/{id}/generate-pi', 'WorkOrderController@generatePI')->name('pi.generate');

    Route::get('pi/{id}/print', 'PIController@printPI')->name('pi.print');
    Route::resource('pi', 'PIController');
    Route::post('pi/all', 'PITableController')->name('pi.get-all');
    Route::get('pi/{id}/to-invoice', 'PIController@getWorkOrderForInvoice')->name('pi.invoice');
    Route::get('invoice/{id}/print', 'PIController@printInvoice')->name('invoice.print');

    Route::get('work-order/{id}/invoice/generate','InvoiceController@workOrderToInvoice' )->name('invoice.view');
    Route::get('invoice/work-order/{id}/generate','InvoiceController@generateInvoice' )->name('invoice.generate');
    Route::get('invoices/work-order','InvoiceController@index' )->name('wo-invoices.index');

    Route::post('invoices/work-order/get','InvoiceTableController' )->name('wo-invoices.get');
});


Route::group(['namespace' => 'withholding'], function () {
    Route::resource('withholdings', 'WithholdingsController');
    //For Datatable
    Route::post('withholdings/get', 'WithholdingsTableController')->name('withholdings.get');
});


Route::group(['namespace' => 'creditnote'], function () {
    Route::post('creditnotes/return_goods', 'CreditNotesController@return_goods')->name('creditnotes.return_goods');
    Route::get('creditnotes/print_creditnote/{creditnote}', 'CreditNotesController@print_creditnote')->name('creditnotes.print_creditnote');
    Route::resource('creditnotes', 'CreditNotesController');
    // for DataTable
    Route::post('creditnotes/get', 'CreditNotesTableController')->name('creditnotes.get');
});

Route::group(['namespace' => 'debitnote'], function () {
    Route::post('debitnotes/return_goods', 'DebitNotesController@return_goods')->name('debitnotes.return_goods');
    Route::get('debitnotes/print_debitnote/{debitnote}', 'DebitNotesController@print_debitnote')->name('debitnotes.print_debitnote');
    Route::resource('debitnotes', 'DebitNotesController');
    // for DataTable
    Route::post('debitnotes/get', 'DebitNotesTableController')->name('debitnotes.get');
});


/**
 * invoices
 */
Route::group(['namespace' => 'standard_invoice'], function () {
    Route::post('standard_invoices/customer/create', 'StandardInvoicesController@create_customer')->name('invoices.create_customer');
    Route::resource('standard_invoices', 'StandardInvoicesController');
});

// payment
Route::group(['namespace' => 'invoice_payment'], function () {
    Route::resource('invoice_payments', 'InvoicePaymentsController');

    // datatable
    Route::post('invoice_payments/get_payments', 'InvoicePaymentsTableController')->name('invoice_payments.get');
});

Route::group(['namespace' => 'invoice'], function () {
    Route::post('bill_status', 'InvoicesController@update_status')->name('bill_status');
    Route::get('pos', 'InvoicesController@pos')->name('invoices.pos');
    Route::post('pos_create', 'InvoicesController@pos_store')->name('invoices.pos_store');
    Route::post('draft_store', 'InvoicesController@draft_store')->name('invoices.draft_store');
    Route::post('drafts_load', 'InvoicesController@drafts_load')->name('invoices.drafts_load');
    Route::get('draft_view/{id}', 'InvoicesController@draft_view')->name('invoices.draft_view');
    Route::post('pos_update', 'InvoicesController@pos_update')->name('invoices.pos_update');
    Route::get('invoices/select', 'InvoicesController@select')->name('invoices.select');
    Route::post('invoices/unallocated_payment', 'InvoicesController@unallocated_payment')->name('invoices.unallocated_payment');

    // project invoice
    Route::get('invoices/work_order', 'InvoicesController@raise_invoice')->name('invoices.raise_invoice');

    Route::get('invoices/edit_project_invoice/{invoice}', 'InvoicesController@edit_project_invoice')->name('invoices.edit_project_invoice');
    Route::post('invoices/update_project_invoice/{invoice}', 'InvoicesController@update_project_invoice')->name('invoices.update_project_invoice');
    Route::get('filter_invoice_quotes', 'InvoicesController@filter_invoice_quotes')->name('invoices.filter_invoice_quotes');
    Route::post('store_project_invoice', 'InvoicesController@store_project_invoice')->name('invoices.store_project_invoice');
    Route::get('invoices/print_document/{id}/{type}', 'InvoicesController@print_document')->name('invoices.print_document');

    // TIMS ETR invoice
    Route::post('invoices/attach_etr', 'InvoicesController@attach_etr')->name('invoices.attach_etr');

    Route::get('uninvoiced_quote', 'InvoicesController@uninvoiced_quote')->name('invoices.uninvoiced_quote');
    Route::resource('invoices', 'InvoicesController');
    //For Datatable
    Route::post('quotes/get_uninvoiced_quote', 'UninvoicedQuoteTableController')->name('invoices.get_uninvoiced_quote');
    Route::post('invoices/get', 'InvoicesTableController')->name('invoices.get');
    // Route::post('invoices/get_payments', 'InvoicePaymentsTableController')->name('invoices.get_payments');

});

Route::group(['namespace' => 'printer'], function () {
    Route::get('browser_print', 'PrinterController@browser_print')->name('pos.browser_print');
    Route::post('register/open', 'RegistersController@open')->name('register.open');
    Route::get('register/close', 'RegistersController@close')->name('register.close');
    Route::get('register/load', 'RegistersController@load')->name('register.load');
});
