<?php

// supplier
Route::group(['namespace' => 'supplier'], function () {
  Route::post('suppliers/bills', 'SuppliersController@bills')->name('suppliers.bills');
  Route::post('suppliers/goods_receive_note', 'SuppliersController@goods_receive_note')->name('suppliers.goods_receive_note');
  Route::post('suppliers/purchaseorders', 'SuppliersController@purchaseorders')->name('suppliers.purchaseorders');
  Route::post('suppliers/search', 'SuppliersController@search')->name('suppliers.search');
  Route::post('suppliers/select', 'SuppliersController@select')->name('suppliers.select');
  Route::post('suppliers/active', 'SuppliersController@active')->name('suppliers.active');
  Route::resource('suppliers', 'SuppliersController');
  // data table
  Route::post('suppliers/get', 'SuppliersTableController')->name('suppliers.get');
});

// purchase requisition
Route::group(['namespace' => 'purchase_request'], function () {
  Route::post('purchase_requests/get_queued', 'PurchaseRequestsController@get_queued')->name('purchase_requests.get_queued');
  Route::post('purchase_requests/store_direct_lpo', 'PurchaseRequestsController@store_direct_lpo')->name('purchase_requests.store_direct_lpo');
  Route::post('purchase_requests/get_requisition_items', 'PurchaseRequestsController@get_requisition_items')->name('purchase_requests.get_requisition_items');
  Route::post('purchase_requests/approve', 'PurchaseRequestsController@approve')->name('purchase_requests.approve');
  Route::post('purchase_requests/store_push', 'PurchaseRequestsController@store_push')->name('purchase_requests.store_push');
  Route::get('purchase_requests/direct_purchase_order', 'PurchaseRequestsController@direct_purchase_order')->name('purchase_requests.direct_purchase_order');
  Route::get('purchase_requests/push_lpo', 'PurchaseRequestsController@push_lpo')->name('purchase_requests.push_lpo');
  Route::resource('purchase_requests', 'PurchaseRequestsController');
  // data table
  Route::post('purchase_requests/get', 'PurchaseRequestsTableController')->name('purchase_requests.get');
});
